/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.BranchProjectTracker;
import org.eclipse.egit.ui.internal.branch.BranchResultDialog;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.CheckoutDialog;
import org.eclipse.egit.ui.internal.dialogs.DeleteBranchDialog;
import org.eclipse.egit.ui.internal.dialogs.RenameBranchDialog;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

public class BranchOperationUI {
    private static final int MODE_CREATE = 1;
    private static final int MODE_CHECKOUT = 2;
    private static final int MODE_DELETE = 3;
    private static final int MODE_RENAME = 4;
    private final Repository repository;
    private String target;
    private final int mode;

    public static BranchOperationUI rename(Repository repository) {
        return new BranchOperationUI(repository, 4);
    }

    public static BranchOperationUI delete(Repository repository) {
        return new BranchOperationUI(repository, 3);
    }

    public static BranchOperationUI create(Repository repository) {
        BranchOperationUI op = new BranchOperationUI(repository, 1);
        return op;
    }

    public static BranchOperationUI checkout(Repository repository) {
        return new BranchOperationUI(repository, 2);
    }

    public static BranchOperationUI checkout(Repository repository, String target) {
        return new BranchOperationUI(repository, target);
    }

    private BranchOperationUI(Repository repository, String target) {
        this.repository = repository;
        this.target = target;
        this.mode = 0;
    }

    private BranchOperationUI(Repository repository, int mode) {
        this.repository = repository;
        this.mode = mode;
    }

    public void start() {
        if (!this.repository.getRepositoryState().canCheckout()) {
            MessageDialog.openError((Shell)this.getShell(), (String)UIText.BranchAction_cannotCheckout, (String)NLS.bind((String)UIText.BranchAction_repositoryState, (Object)this.repository.getRepositoryState().getDescription()));
            return;
        }
        if (this.target == null) {
            this.target = this.getTargetWithDialog();
        }
        if (this.target == null) {
            return;
        }
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
        String jobname = NLS.bind((String)UIText.BranchAction_checkingOut, (Object)repoName, (Object)this.target);
        final boolean restore = Activator.getDefault().getPreferenceStore().getBoolean("restore_projects_on_checkout");
        final BranchOperation bop = new BranchOperation(this.repository, this.target, !restore);
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        if (restore) {
                            final BranchProjectTracker tracker = new BranchProjectTracker(BranchOperationUI.this.repository);
                            final AtomicReference memento = new AtomicReference();
                            bop.addPreExecuteTask(new IEGitOperation.PreExecuteTask(){

                                public void preExecute(Repository pRepo, IProgressMonitor pMonitor) throws CoreException {
                                    memento.set(tracker.snapshot());
                                }
                            });
                            bop.addPostExecuteTask(new IEGitOperation.PostExecuteTask(){

                                public void postExecute(Repository pRepo, IProgressMonitor pMonitor) throws CoreException {
                                    IMemento snapshot = (IMemento)memento.get();
                                    if (snapshot == null) {
                                        return;
                                    }
                                    tracker.save(snapshot).restore(pMonitor);
                                }
                            });
                        }
                        bop.execute(monitor);
                    }
                    catch (CoreException e) {
                        switch (bop.getResult().getStatus()) {
                            case CONFLICTS: 
                            case NONDELETED: {
                                break;
                            }
                            default: {
                                IStatus iStatus = Activator.createErrorStatus(UIText.BranchAction_branchFailed, e);
                                GitLightweightDecorator.refresh();
                                return iStatus;
                            }
                        }
                        GitLightweightDecorator.refresh();
                    }
                }
                finally {
                    GitLightweightDecorator.refresh();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family.equals(JobFamilies.CHECKOUT)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                BranchResultDialog.show(bop.getResult(), BranchOperationUI.this.repository, BranchOperationUI.this.target);
            }
        });
        job.schedule();
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (!this.repository.getRepositoryState().canCheckout()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)BranchOperationUI.this.getShell(), (String)UIText.BranchAction_cannotCheckout, (String)NLS.bind((String)UIText.BranchAction_repositoryState, (Object)BranchOperationUI.this.repository.getRepositoryState().getDescription()));
                }
            });
            return;
        }
        if (this.target == null) {
            this.target = this.getTargetWithDialog();
        }
        if (this.target == null) {
            return;
        }
        BranchOperation bop = new BranchOperation(this.repository, this.target);
        bop.execute(monitor);
        BranchResultDialog.show(bop.getResult(), this.repository, this.target);
    }

    private String getTargetWithDialog() {
        CheckoutDialog dialog;
        switch (this.mode) {
            case 2: {
                dialog = new CheckoutDialog(this.getShell(), this.repository);
                break;
            }
            case 1: {
                CreateBranchWizard wiz;
                try {
                    wiz = new CreateBranchWizard(this.repository, this.repository.getFullBranch());
                }
                catch (IOException iOException) {
                    wiz = new CreateBranchWizard(this.repository);
                }
                new WizardDialog(this.getShell(), (IWizard)wiz).open();
                return null;
            }
            case 3: {
                new DeleteBranchDialog(this.getShell(), this.repository).open();
                return null;
            }
            case 4: {
                new RenameBranchDialog(this.getShell(), this.repository).open();
                return null;
            }
            default: {
                return null;
            }
        }
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getRefName();
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }
}

