/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.rebase.RebaseResultDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RebaseHelper {
    public static void runRebaseJob(final Repository repository, String jobname, Ref ref) {
        final RebaseOperation rebase = new RebaseOperation(repository, ref);
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                    throw new IllegalStateException("Can't start rebase if repository state isn't SAFE");
                }
                try {
                    rebase.execute(monitor);
                }
                catch (CoreException e) {
                    if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                        try {
                            new RebaseOperation(repository, RebaseCommand.Operation.ABORT).execute(monitor);
                        }
                        catch (CoreException e1) {
                            return RebaseHelper.createMultiStatus(e, e1);
                        }
                    }
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule(rebase.getSchedulingRule());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                IStatus result = cevent.getJob().getResult();
                if (result.getSeverity() == 8) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openInformation((Shell)shell, (String)UIText.RebaseCurrentRefCommand_RebaseCanceledTitle, (String)UIText.RebaseCurrentRefCommand_RebaseCanceledMessage);
                        }
                    });
                } else if (result.isOK()) {
                    RebaseResultDialog.show(rebase.getResult(), repository);
                }
            }
        });
        job.schedule();
    }

    private static IStatus createMultiStatus(CoreException originalException, CoreException e) {
        IStatus childStatus = Activator.createErrorStatus(originalException.getMessage(), originalException);
        return new MultiStatus(Activator.getPluginId(), 4, new IStatus[]{childStatus}, e.getMessage(), (Throwable)e);
    }
}

