/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.synchronize.compare.ComparisonDataSource;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.mapping.SaveableComparison;

public class GitCompareInput
implements ISynchronizationCompareInput {
    private final String name;
    private final ObjectId ancestorId;
    private final ObjectId baseId;
    private final ObjectId remoteId;
    private final RevCommit ancestorCommit;
    private final RevCommit remoteCommit;
    protected final RevCommit baseCommit;
    protected final Repository repo;
    protected final String gitPath;

    public GitCompareInput(Repository repo, ComparisonDataSource ancestorDataSource, ComparisonDataSource baseDataSource, ComparisonDataSource remoteDataSource, String gitPath) {
        this.repo = repo;
        this.gitPath = gitPath;
        this.baseId = baseDataSource.getObjectId();
        this.remoteId = remoteDataSource.getObjectId();
        this.baseCommit = baseDataSource.getRevCommit();
        this.ancestorId = ancestorDataSource.getObjectId();
        this.remoteCommit = remoteDataSource.getRevCommit();
        this.ancestorCommit = ancestorDataSource.getRevCommit();
        this.name = gitPath.lastIndexOf(47) < 0 ? gitPath : gitPath.substring(gitPath.lastIndexOf(47) + 1);
    }

    public String getName() {
        return this.name;
    }

    public Image getImage() {
        return null;
    }

    public int getKind() {
        return 0;
    }

    public ITypedElement getAncestor() {
        if (this.objectExist(this.ancestorCommit, this.ancestorId)) {
            return CompareUtils.getFileRevisionTypedElement(this.gitPath, this.ancestorCommit, this.repo, this.ancestorId);
        }
        return null;
    }

    public ITypedElement getLeft() {
        return CompareUtils.getFileRevisionTypedElement(this.gitPath, this.baseCommit, this.repo, this.baseId);
    }

    public ITypedElement getRight() {
        return CompareUtils.getFileRevisionTypedElement(this.gitPath, this.remoteCommit, this.repo, this.remoteId);
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
    }

    public void copy(boolean leftToRight) {
    }

    private boolean objectExist(RevCommit commit, ObjectId id) {
        return commit != null && id != null && !id.equals((AnyObjectId)ObjectId.zeroId());
    }

    public SaveableComparison getSaveable() {
        return null;
    }

    public void prepareInput(CompareConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        configuration.setLeftLabel(GitCompareInput.getFileRevisionLabel(this.getLeft()));
        configuration.setRightLabel(GitCompareInput.getFileRevisionLabel(this.getRight()));
    }

    public String getFullPath() {
        return this.gitPath;
    }

    public boolean isCompareInputFor(Object object) {
        return false;
    }

    public static String getFileRevisionLabel(ITypedElement element) {
        if (element instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement castElement = (FileRevisionTypedElement)element;
            if ("Index".equals(castElement.getContentIdentifier())) {
                return NLS.bind((String)UIText.GitCompareFileRevisionEditorInput_StagedVersion, (Object)element.getName());
            }
            return NLS.bind((String)UIText.GitCompareFileRevisionEditorInput_RevisionLabel, (Object[])new Object[]{element.getName(), CompareUtils.truncatedRevision(castElement.getContentIdentifier()), castElement.getAuthor()});
        }
        if (element instanceof LocalResourceTypedElement) {
            return NLS.bind((String)UIText.GitCompareFileRevisionEditorInput_LocalVersion, (Object)element.getName());
        }
        return element.getName();
    }
}

