/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;

public class GitModelRoot {
    private final GitSynchronizeDataSet gsds;
    private GitModelObject[] children;

    public GitModelRoot(GitSynchronizeDataSet gsds) {
        this.gsds = gsds;
    }

    public GitSynchronizeDataSet getGsds() {
        return this.gsds;
    }

    public GitModelObject[] getChildren() {
        return this.getChildrenImpl();
    }

    public void dispose() {
        this.disposeOldChildren();
        this.gsds.dispose();
    }

    private GitModelObject[] getChildrenImpl() {
        ArrayList<GitModelRepository> result = new ArrayList<GitModelRepository>();
        try {
            if (this.gsds.size() == 1) {
                GitSynchronizeData gsd = (GitSynchronizeData)this.gsds.iterator().next();
                GitModelRepository repoModel = new GitModelRepository(gsd);
                return repoModel.getChildren();
            }
            for (GitSynchronizeData data : this.gsds) {
                GitModelRepository repoModel = new GitModelRepository(data);
                if (repoModel.getChildren().length <= 0) continue;
                result.add(repoModel);
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        this.disposeOldChildren();
        this.children = result.toArray(new GitModelObject[result.size()]);
        return this.children;
    }

    private void disposeOldChildren() {
        if (this.children == null) {
            return;
        }
        GitModelObject[] gitModelObjectArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            GitModelObject child = gitModelObjectArray[n2];
            child.dispose();
            ++n2;
        }
    }
}

