/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.activitygroup.editpolicy.notifiers;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.GroupRequestAdvisor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IContainerNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IGroupRequestAdvisor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.editpolicy.notifiers.GroupListenerEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.request.AbstractGroupRequest;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.request.IGroupRequest;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.utils.DebugUtils;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupNotifyingOnMoveEditPolicy
extends GroupListenerEditPolicy {
    public GroupNotifyingOnMoveEditPolicy(IContainerNodeDescriptor groupDescriptor) {
        super(groupDescriptor);
    }

    public Command getCommand(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest req = (ChangeBoundsRequest)request;
            CompositeCommand cc = new CompositeCommand("GroupNotifyingEditPolicy ");
            for (EditPart editPart : Utils.getTargetedEditPart(req)) {
                ICommand cmd = this.getGroupRequestAdvisor().notifyGroupFramework(new AbstractGroupRequest((IGraphicalEditPart)this.getHost(), (Request)Utils.getChangeBoundsRequestCopy(req, editPart), (IAdaptable)editPart, this.getTargetGroupDescriptor((IAdaptable)editPart)){

                    public IGroupRequest.GroupRequestType getGroupRequestType() {
                        return IGroupRequest.GroupRequestType.MOVE;
                    }
                });
                if (cmd == null || !cmd.canExecute()) continue;
                cc.compose((IUndoableOperation)cmd);
            }
            this.stopMovingPartState(req);
            if (cc != null && cc.canExecute()) {
                return new ICommandProxy((ICommand)cc);
            }
        }
        return null;
    }

    public void stopMovingPartState(ChangeBoundsRequest req) {
        Iterable<IGraphicalEditPart> targetedEditPart = Utils.getTargetedEditPart(req);
        this.stopMovingParts(targetedEditPart);
    }

    protected void stopMovingParts(Iterable<IGraphicalEditPart> targetedEditPart) {
        if (targetedEditPart != null) {
            for (EditPart editPart : targetedEditPart) {
                EditPolicy editPolicy = editPart.getEditPolicy((Object)"GroupFramework_NotifyingOnMoveEditPolicy");
                if (editPolicy instanceof GroupNotifyingOnMoveEditPolicy) {
                    GroupNotifyingOnMoveEditPolicy editPolicy2 = (GroupNotifyingOnMoveEditPolicy)editPolicy;
                    if (DebugUtils.isDebugging()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(Utils.getCorrectLabel(editPolicy2.getEObject()));
                        stringBuilder.append(" is stoping to move");
                        DebugUtils.getLog().debug(stringBuilder.toString());
                    }
                    editPolicy2.stopMoving();
                }
                this.stopMovingParts(editPart.getChildren());
            }
        }
    }

    public void initMovingPartState(ChangeBoundsRequest req) {
        Iterable<IGraphicalEditPart> targetedEditPart = Utils.getTargetedEditPart(req);
        this.startMovingParts(req, targetedEditPart);
    }

    protected void startMovingParts(ChangeBoundsRequest req, Iterable<IGraphicalEditPart> targetedEditPart) {
        if (targetedEditPart != null) {
            for (EditPart editPart : targetedEditPart) {
                EditPolicy editPolicy = editPart.getEditPolicy((Object)"GroupFramework_NotifyingOnMoveEditPolicy");
                if (editPolicy instanceof GroupNotifyingOnMoveEditPolicy) {
                    GroupNotifyingOnMoveEditPolicy editPolicy2 = (GroupNotifyingOnMoveEditPolicy)editPolicy;
                    if (DebugUtils.isDebugging()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(Utils.getCorrectLabel(editPolicy2.getEObject()));
                        stringBuilder.append(" is start to move");
                        DebugUtils.getLog().debug(stringBuilder.toString());
                    }
                    editPolicy2.startMoving(req);
                }
                this.startMovingParts(req, editPart.getChildren());
            }
        }
    }

    @Override
    protected IGroupRequestAdvisor getGroupRequestAdvisor() {
        return GroupRequestAdvisor.getInstance();
    }

    public boolean understandsRequest(Request req) {
        return req instanceof ChangeBoundsRequest;
    }
}

