/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.gef.ui.internal.figures.DiamondFigure;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.UMLEditPartFactory;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.BehaviorPropertyNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.figures.WrappedLabel;
import org.eclipse.papyrus.uml.diagram.activity.locator.LinkedBehaviorLocator;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLParserProvider;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultilineLabelDirectEditManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CornerBentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.Feature;

public class DecisionInputEditPart
extends LabelEditPart
implements ITextAwareEditPart,
IBorderItemEditPart {
    public static final int VISUAL_ID = 5043;
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    private String defaultText;
    protected int directEditionMode = 0;
    protected IDirectEditorConfiguration configuration;
    static final Color THIS_BACK;

    static {
        DecisionInputEditPart.registerSnapBackPosition((String)UMLVisualIDRegistry.getType(5043), (Point)new Point(0, 0));
        THIS_BACK = new Color(null, 248, 249, 214);
    }

    public DecisionInputEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new UMLTextSelectionEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new BehaviorPropertyNodeEditPolicy());
    }

    public IBorderItemLocator getBorderItemLocator() {
        IFigure parentFigure = this.getFigure().getParent();
        if (parentFigure != null && parentFigure.getLayoutManager() != null) {
            Object constraint = parentFigure.getLayoutManager().getConstraint(this.getFigure());
            return (IBorderItemLocator)constraint;
        }
        return null;
    }

    public void refreshBounds() {
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        this.getBorderItemLocator().setConstraint(new Rectangle(x, y, width, height));
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getText();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getText();
        }
        if (figure instanceof LinkAndCornerBentWithTextFigure) {
            return ((LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().getText();
        }
        return ((Label)figure).getText();
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setText(text);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setText(text);
        } else if (figure instanceof LinkAndCornerBentWithTextFigure) {
            ((LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().setText(text);
        } else {
            ((Label)figure).setText(text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getIcon();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getIcon();
        }
        if (figure instanceof LinkAndCornerBentWithTextFigure) {
            return ((LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().getIcon();
        }
        return ((Label)figure).getIcon();
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setIcon(icon);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setIcon(icon);
        } else if (figure instanceof LinkAndCornerBentWithTextFigure) {
            ((LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().setIcon(icon);
        } else {
            ((Label)figure).setIcon(icon);
        }
    }

    public void setLabel(IFigure figure) {
        this.unregisterVisuals();
        this.setFigure(figure);
        this.defaultText = this.getLabelTextHelper(figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    protected Image getLabelIcon() {
        return null;
    }

    protected String getLabelText() {
        boolean decisionSet;
        boolean bl = decisionSet = ((DecisionNode)this.resolveSemanticElement()).getDecisionInput() != null;
        if (decisionSet) {
            String text = null;
            EObject parserElement = this.getParserElement();
            if (parserElement != null && this.getParser() != null) {
                text = this.getParser().getPrintString((IAdaptable)new EObjectAdapter(parserElement), this.getParserOptions().intValue());
            }
            if (text == null || text.length() == 0) {
                text = this.defaultText;
            }
            return text;
        }
        return "";
    }

    public void setLabelText(String text) {
        EditPolicy sfEditPolicy;
        this.setLabelTextHelper(this.getFigure(), text);
        EditPolicy pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (pdEditPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    public String getEditText() {
        boolean decisionSet;
        boolean bl = decisionSet = ((DecisionNode)this.resolveSemanticElement()).getDecisionInput() != null;
        if (this.getParserElement() == null || this.getParser() == null || !decisionSet) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    protected boolean isEditable() {
        return this.getParser() != null;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = DecisionInputEditPart.this.getParserElement();
                    final IParser parser = DecisionInputEditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)DecisionInputEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                            public void run() {
                                this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = UMLParserProvider.getParser(UMLElementTypes.DecisionNode_3038, this.getParserElement(), UMLVisualIDRegistry.getType(5043));
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, MultilineLabelDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), UMLEditPartFactory.getTextCellEditorLocator(this)));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void performDirectEdit() {
        boolean decisionSet;
        boolean bl = decisionSet = ((DecisionNode)this.resolveSemanticElement()).getDecisionInput() != null;
        if (decisionSet) {
            this.getManager().show();
        }
    }

    protected void performDirectEdit(Point eventLocation) {
        boolean decisionSet;
        boolean bl = decisionSet = ((DecisionNode)this.resolveSemanticElement()).getDecisionInput() != null;
        if (this.getManager() instanceof TextDirectEditManager && decisionSet) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    private void performDirectEdit(char initialCharacter) {
        boolean decisionSet;
        boolean bl = decisionSet = ((DecisionNode)this.resolveSemanticElement()).getDecisionInput() != null;
        if (this.getManager() instanceof TextDirectEditManager && decisionSet) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        boolean decisionSet;
        boolean bl = decisionSet = ((DecisionNode)this.resolveSemanticElement()).getDecisionInput() != null;
        if (!decisionSet) {
            return;
        }
        final Request theRequest = request;
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return;
            }
            case 4: {
                this.updateExtendedEditorConfiguration();
                if (this.configuration == null || this.configuration.getLanguage() == null) {
                    this.performDefaultDirectEditorEdit(theRequest);
                    break;
                }
                this.configuration.preEditAction((Object)this.resolveSemanticElement());
                Dialog dialog = null;
                if (this.configuration instanceof IAdvancedEditorConfiguration) {
                    dialog = ((IAdvancedEditorConfiguration)this.configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()));
                } else if (this.configuration instanceof IDirectEditorConfiguration) {
                    dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()), this.configuration);
                } else {
                    return;
                }
                final Dialog finalDialog = dialog;
                if (dialog.open() != 0) break;
                TransactionalEditingDomain domain = this.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        DecisionInputEditPart.this.configuration.postEditAction((Object)DecisionInputEditPart.this.resolveSemanticElement(), ((ILabelEditorDialog)finalDialog).getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
                break;
            }
            case 2: {
                try {
                    this.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            if (DecisionInputEditPart.this.isActive() && DecisionInputEditPart.this.isEditable()) {
                                if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                                    Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                                    DecisionInputEditPart.this.performDirectEdit(initialChar.charValue());
                                } else if (theRequest instanceof DirectEditRequest && DecisionInputEditPart.this.getEditText().equals(DecisionInputEditPart.this.getLabelText())) {
                                    DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                                    DecisionInputEditPart.this.performDirectEdit(editRequest.getLocation());
                                } else {
                                    DecisionInputEditPart.this.performDirectEdit();
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    protected void setVisibility(boolean vis) {
        Behavior decisionInput;
        EObject element = this.resolveSemanticElement();
        if (element instanceof DecisionNode && (decisionInput = ((DecisionNode)element).getDecisionInput()) == null) {
            vis = false;
        }
        super.setVisibility(vis);
    }

    protected void refreshLabel() {
        EditPolicy sfEditPolicy;
        EditPolicy pdEditPolicy;
        EditPolicy maskLabelPolicy = this.getEditPolicy("MaskManagedLabelPolicy");
        if (maskLabelPolicy == null) {
            this.setLabelTextHelper(this.getFigure(), this.getLabelText());
            this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        }
        if ((pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextUnderline(style.isUnderline());
        }
        if (this.resolveSemanticElement() instanceof Feature) {
            if (((Feature)this.resolveSemanticElement()).isStatic()) {
                ((WrappingLabel)this.getFigure()).setTextUnderline(true);
            } else {
                ((WrappingLabel)this.getFigure()).setTextUnderline(false);
            }
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, (NotificationListener)this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = DecisionInputEditPart.this.getLabelTextHelper(DecisionInputEditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return this.getPrimaryView();
    }

    public int getDirectEditionType() {
        if (this.checkExtendedEditor()) {
            this.initExtendedEditorConfiguration();
            return 4;
        }
        if (this.checkDefaultEdition()) {
            return 2;
        }
        return 8;
    }

    protected boolean checkExtendedEditor() {
        if (this.resolveSemanticElement() != null) {
            return DirectEditorsUtil.hasSpecificEditorConfiguration((String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
        return false;
    }

    protected boolean checkDefaultEdition() {
        return this.getParser() != null;
    }

    protected void initExtendedEditorConfiguration() {
        if (this.configuration == null) {
            String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
            this.configuration = languagePreferred != null && !languagePreferred.equals("") ? DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName()) : DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
    }

    protected void updateExtendedEditorConfiguration() {
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
        if (languagePreferred != null && !languagePreferred.equals("") && languagePreferred != this.configuration.getLanguage()) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        } else if ("Simple Direct Editor".equals(languagePreferred)) {
            this.configuration = null;
        }
    }

    protected void performDefaultDirectEditorEdit(final Request theRequest) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    if (DecisionInputEditPart.this.isActive() && DecisionInputEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            DecisionInputEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && DecisionInputEditPart.this.getEditText().equals(DecisionInputEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            DecisionInputEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            DecisionInputEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
                this.refreshVisibility();
            }
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createFigure() {
        IFigure label = this.createFigurePrim();
        this.defaultText = this.getLabelTextHelper(label);
        return label;
    }

    protected IFigure createFigurePrim() {
        return new LinkAndCornerBentWithTextFigure();
    }

    public class LinkAndCornerBentWithTextFigure
    extends CornerBentFigure {
        private WrappedLabel fCornerBentContent;
        private PolylineShape fLinkToBehaviorProperty;

        public LinkAndCornerBentWithTextFigure() {
            this.setBackgroundColor(THIS_BACK);
            this.createContents();
        }

        private void createContents() {
            this.fCornerBentContent = new WrappedLabel();
            this.add((IFigure)this.fCornerBentContent);
            this.fLinkToBehaviorProperty = new PolylineShape();
            this.fLinkToBehaviorProperty.setLineWidth(1);
            this.fLinkToBehaviorProperty.setLineStyle(2);
            this.addFigureListener(new FigureListener(){

                public void figureMoved(IFigure source) {
                    LinkAndCornerBentWithTextFigure.this.refreshLinkToBehaviorProperty();
                }
            });
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.getLinkToBehaviorProperty().setVisible(visible);
        }

        private void refreshLinkToBehaviorProperty() {
            if (this.getLinkToBehaviorProperty().getParent() == null) {
                this.getParent().add((IFigure)this.getLinkToBehaviorProperty());
            }
            if (this.getParent() != null && this.getParent().getParent() instanceof BorderedNodeFigure) {
                BorderedNodeFigure gParent = (BorderedNodeFigure)this.getParent().getParent();
                Rectangle parentBounds = gParent.getHandleBounds().getCopy();
                Point parentCenter = parentBounds.getCenter();
                DiamondFigure diamond = (DiamondFigure)gParent.getMainFigure();
                Rectangle currentBounds = ((LinkedBehaviorLocator)DecisionInputEditPart.this.getBorderItemLocator()).getCorrectItemLocation((IFigure)this);
                Point end = BehaviorPropertyNodeEditPolicy.getAppropriateBorderPoint(parentCenter, currentBounds);
                Point start = BehaviorPropertyNodeEditPolicy.getIntersectionPoint(diamond.getPolygonPoints(), parentCenter, end);
                if (start == null) {
                    start = parentCenter;
                }
                Rectangle linkBounds = new Rectangle(start, end);
                this.getLinkToBehaviorProperty().setStart(start.translate(linkBounds.getLocation().getNegated()));
                this.getLinkToBehaviorProperty().setEnd(end.translate(linkBounds.getLocation().getNegated()));
                this.getLinkToBehaviorProperty().setBounds(linkBounds);
            }
        }

        public WrappedLabel getCornerBentContent() {
            return this.fCornerBentContent;
        }

        public PolylineShape getLinkToBehaviorProperty() {
            return this.fLinkToBehaviorProperty;
        }
    }
}

