/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.common.plugin;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.ocl.examples.common.label.ILabelGenerator;
import org.eclipse.ocl.examples.common.plugin.OCLExamplesCommonPlugin;

class LabelGeneratorRegistryReader
extends RegistryReader {
    static final String TAG_GENERATOR = "generator";
    static final String ATT_FOR = "for";
    static final String ATT_CLASS = "class";

    public LabelGeneratorRegistryReader() {
        super(Platform.getExtensionRegistry(), OCLExamplesCommonPlugin.getPlugin().getBundle().getSymbolicName(), "label_generator");
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_GENERATOR)) {
            String helpedClass = element.getAttribute(ATT_FOR);
            if (helpedClass == null) {
                this.logMissingAttribute(element, ATT_FOR);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                Class<?> loadedClass;
                try {
                    loadedClass = Thread.currentThread().getContextClassLoader().loadClass(helpedClass);
                }
                catch (ClassNotFoundException e) {
                    OCLExamplesCommonPlugin.logError("Failed to load '" + helpedClass + "'", e);
                    return false;
                }
                if (add) {
                    Object previous = ILabelGenerator.Registry.INSTANCE.install(loadedClass, new LabelGeneratorDescriptor(element, ATT_CLASS));
                    if (previous instanceof LabelGeneratorDescriptor) {
                        LabelGeneratorDescriptor descriptor = (LabelGeneratorDescriptor)previous;
                        OCLExamplesCommonPlugin.INSTANCE.log("Both '" + descriptor.getElement().getContributor().getName() + "' and '" + element.getContributor().getName() + "' register an invocation delegate factory for '" + helpedClass + "'");
                    }
                    return true;
                }
                ILabelGenerator.Registry.INSTANCE.uninstall(loadedClass);
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LabelGeneratorDescriptor
    extends RegistryReader.PluginClassDescriptor
    implements ILabelGenerator.Descriptor {
        protected ILabelGenerator<?> labelGenerator;

        public LabelGeneratorDescriptor(IConfigurationElement e, String attrName) {
            super(e, attrName);
        }

        @Override
        public ILabelGenerator<?> getLabelGenerator() {
            if (this.labelGenerator == null) {
                this.labelGenerator = (ILabelGenerator)this.createInstance();
            }
            return this.labelGenerator;
        }

        public IConfigurationElement getElement() {
            return this.element;
        }
    }
}

