/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.common.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.examples.common.label.AbstractLabelGenerator;
import org.eclipse.ocl.examples.common.label.ILabelGenerator;
import org.eclipse.ocl.examples.common.label.LabelGeneratorRegistry;
import org.eclipse.ocl.examples.common.utils.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreUtils {
    public static ILabelGenerator.Registry SIMPLE_NAME_REGISTRY = new LabelGeneratorRegistry(ILabelGenerator.Registry.INSTANCE);
    public static ILabelGenerator.Registry QUALIFIED_NAME_REGISTRY = new LabelGeneratorRegistry(ILabelGenerator.Registry.INSTANCE);

    static {
        SIMPLE_NAME_REGISTRY.install(ENamedElement.class, new AbstractLabelGenerator<ENamedElement>(ENamedElement.class){

            @Override
            public void buildLabelFor(ILabelGenerator.Builder labelBuilder, ENamedElement labelledObject) {
                String name = labelledObject.getName();
                if (name != null) {
                    labelBuilder.appendString(name);
                } else {
                    labelBuilder.appendString("<null-named-");
                    labelBuilder.appendString(labelledObject.getClass().getSimpleName());
                    labelBuilder.appendString(">");
                }
            }
        });
        QUALIFIED_NAME_REGISTRY.install(ENamedElement.class, new AbstractLabelGenerator<ENamedElement>(ENamedElement.class){

            @Override
            public void buildLabelFor(ILabelGenerator.Builder labelBuilder, ENamedElement labelledObject) {
                String name;
                EObject eContainer = labelledObject.eContainer();
                if (eContainer != null) {
                    labelBuilder.getRegistry().buildSubLabelFor(labelBuilder, eContainer);
                    labelBuilder.appendString("::");
                }
                if ((name = labelledObject.getName()) != null) {
                    labelBuilder.appendString(name);
                } else {
                    labelBuilder.appendString("<null-named-");
                    labelBuilder.appendString(labelledObject.getClass().getSimpleName());
                    labelBuilder.appendString(">");
                }
            }
        });
    }

    public static <E extends EObject> E copy(E newObject) {
        return (E)EcoreUtil.copy(newObject);
    }

    public static String diagnoseUnresolvedProxies(URI contextURI, Map<EObject, Collection<EStructuralFeature.Setting>> map) {
        if (map.isEmpty()) {
            return null;
        }
        HashMap<String, Map.Entry<EObject, Collection<EStructuralFeature.Setting>>> unresolvedURIs = new HashMap<String, Map.Entry<EObject, Collection<EStructuralFeature.Setting>>>(map.size());
        for (Map.Entry<EObject, Collection<EStructuralFeature.Setting>> entry : map.entrySet()) {
            String uriString;
            EObject key = entry.getKey();
            URI uri = EcoreUtil.getURI((EObject)key);
            if (uri == null || unresolvedURIs.containsKey(uriString = uri.toString())) continue;
            unresolvedURIs.put(uriString, entry);
        }
        StringBuilder s = new StringBuilder();
        s.append("Unresolved URIs in '" + String.valueOf(contextURI) + "' :");
        for (Map.Entry unresolvedURI : unresolvedURIs.entrySet()) {
            s.append("\n    '" + (String)unresolvedURI.getKey() + "'");
        }
        return s.toString();
    }

    public static String formatMultiplicity(ETypedElement typedElement) {
        int upper;
        if (typedElement == null) {
            return "";
        }
        int lower = typedElement.getLowerBound();
        if (lower == (upper = typedElement.getUpperBound())) {
            return Integer.toString(lower);
        }
        if (lower == 0) {
            if (upper < 0) {
                return "*";
            }
            if (upper == 1) {
                return "?";
            }
        } else if (lower == 1 && upper < 0) {
            return "+";
        }
        return String.valueOf(Integer.toString(lower)) + ".." + (upper >= 0 ? Integer.toString(upper) : "*");
    }

    public static String formatOrdered(ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isOrdered() && typedElement.isMany() : false;
        return isOrdered ? "{ordered}" : "";
    }

    public static String formatString(String name) {
        return name != null ? name : "<null>";
    }

    public static String formatUnique(ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isUnique() && typedElement.isMany() : false;
        return isOrdered ? "{unique}" : "";
    }

    public static <T extends Adapter> T getAdapter(Notifier notifier, Class<T> adapterClass) {
        if (notifier == null) {
            return null;
        }
        return EcoreUtils.getAdapter((List<Adapter>)notifier.eAdapters(), adapterClass);
    }

    public static <T extends Adapter> T getAdapter(List<Adapter> eAdapters, Class<T> adapterClass) {
        return (T)EcoreUtil.getAdapter(eAdapters, adapterClass);
    }

    public static EClassifier getEType(EObject sourceObject, EStructuralFeature feature) {
        EGenericType targetGenericType = feature.getEGenericType();
        ETypeParameter targetTypeParameter = targetGenericType.getETypeParameter();
        if (targetTypeParameter != null && sourceObject != null) {
            EClass sourceGenericType = feature.getEContainingClass();
            EObject typeParameterContainer = targetTypeParameter.eContainer();
            EClass sourceClass = sourceObject.eClass();
            EList allSourceGenericSuperTypes = sourceClass.getEAllGenericSuperTypes();
            for (EGenericType sourceGenericSuperType : allSourceGenericSuperTypes) {
                if (sourceGenericSuperType.getERawType() != typeParameterContainer) continue;
                EList sourceTypeArguments = sourceGenericSuperType.getETypeArguments();
                int i = sourceGenericType.getETypeParameters().indexOf((Object)targetTypeParameter);
                if (i < 0 || i >= sourceTypeArguments.size()) continue;
                EGenericType sourceTypeArgument = (EGenericType)sourceTypeArguments.get(i);
                return sourceTypeArgument.getERawType();
            }
        }
        return targetGenericType.getERawType();
    }

    public static Map.Entry<String, String> getEAnnotationDetail(Constraint constraint) {
        int indexOfKey;
        EAnnotation eAnnotation;
        String keyName;
        EList constrainedElements = constraint.getConstrainedElements();
        if (constrainedElements.isEmpty()) {
            return null;
        }
        EModelElement constrainedElement = (EModelElement)constrainedElements.get(0);
        String stereotype = constraint.getStereotype();
        if ("invariant".equals(stereotype)) {
            EOperation apiOperation;
            keyName = constraint.getName();
            if (constrainedElement instanceof EClass && (apiOperation = EcoreUtils.getEcoreInvariant((EClass)constrainedElement, keyName)) != null) {
                constrainedElement = apiOperation;
                keyName = "body";
            }
        } else {
            keyName = "derivation".equals(stereotype) ? "derivation" : ("initial".equals(stereotype) ? "initial" : ("body".equals(stereotype) ? "body" : null));
        }
        if ((eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)constrainedElement)) == null) {
            return null;
        }
        EMap details = eAnnotation.getDetails();
        if (keyName != null && (indexOfKey = details.indexOfKey((Object)keyName)) >= 0) {
            return (Map.Entry)details.get(indexOfKey);
        }
        return null;
    }

    public static EOperation getEcoreInvariant(EClass eClass, String name) {
        for (EOperation eOperation : eClass.getEOperations()) {
            if (!ClassUtils.equals(name, eOperation.getName()) || !EcoreUtil.isInvariant((EOperation)eOperation)) continue;
            return eOperation;
        }
        return null;
    }

    public static <T> int getFeatureID(Notification notification, T expectedNotifier, Class<T> featureClass) {
        if (expectedNotifier == null) {
            return -1;
        }
        Object notifier = notification.getNotifier();
        if (notifier != expectedNotifier) {
            return -1;
        }
        T castNotifier = ClassUtils.asClassOrNull(notifier, featureClass);
        if (castNotifier == null) {
            throw new IllegalArgumentException("EcoreUtils.getFeatureID: " + featureClass.getName() + " for a " + notifier.getClass().getName());
        }
        return notification.getFeatureID(featureClass);
    }

    public static <T extends ENamedElement> T getNamedElement(Collection<T> elements, String name) {
        if (elements == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (!ClassUtils.equals(name, element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    public static <T extends ENamedElement, R extends T> R getNamedElement(Collection<T> elements, String name, Class<R> returnClass) {
        if (elements == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (returnClass == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (!returnClass.isAssignableFrom(element.getClass()) || !ClassUtils.equals(name, element.getName())) continue;
            return (R)element;
        }
        return null;
    }

    public static String qualifiedNameFor(Object object) {
        return QUALIFIED_NAME_REGISTRY.labelFor(object);
    }

    public static String simpleNameFor(Object object) {
        return SIMPLE_NAME_REGISTRY.labelFor(object);
    }
}

