/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.HashSet;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.OperationForbiddenException;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.Constants;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.policies.CompactStateInvariantItemSemanticEditPolicyCN;

public class CustomCompactStateInvariantItemSemanticEditPolicy
extends CompactStateInvariantItemSemanticEditPolicyCN {
    public Command getCommand(Request request) {
        if (request.getType() == "delete") {
            try {
                View view = (View)this.getHost().getModel();
                HashSet<View> viewsToRemove = new HashSet<View>();
                if (view.getType().equals(Constants.compactStateInvariantId)) {
                    viewsToRemove.addAll(StateInvariantUtils.getViewsToHide(view));
                }
                if (viewsToRemove.size() > 0) {
                    CompoundCommand compoundCommand = new CompoundCommand(Messages.hideStateInvariant);
                    compoundCommand.add(super.getCommand(request));
                    for (View viewToRemove : viewsToRemove) {
                        compoundCommand.add((Command)new ICommandProxy((ICommand)new DeleteCommand(viewToRemove)));
                    }
                    return compoundCommand;
                }
            }
            catch (OperationForbiddenException e) {
                return UnexecutableCommand.INSTANCE;
            }
        }
        return super.getCommand(request);
    }
}

