/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;

public class DimensioningArrowFigure
extends PapyrusNodeFigure {
    private static final int PREFERRED_HEIGHT = 11;

    public DimensioningArrowFigure() {
        this.setShadow(false);
        this.setBorder(null);
    }

    public void paintFigure(Graphics g) {
        g.pushState();
        int middleX = this.bounds.x + this.bounds.width / 2;
        int middleY = this.bounds.y + this.bounds.height / 2;
        int x = this.bounds.x;
        int w = this.bounds.width - 1;
        int horizontalGap = w / 3;
        int arrowSize = Math.max(Math.min(w / 5, 7), 3);
        int verticalLineSize = arrowSize * 3;
        g.setLineWidth(1);
        g.drawLine(x, middleY, middleX - horizontalGap / 2, middleY);
        g.drawLine(middleX + horizontalGap / 2, middleY, x + w, middleY);
        g.drawLine(x, middleY - verticalLineSize / 2, x, middleY + verticalLineSize / 2);
        g.drawLine(x + w, middleY - verticalLineSize / 2, x + w, middleY + verticalLineSize / 2);
        g.setAntialias(1);
        g.drawLine(x, middleY, x + arrowSize, middleY - arrowSize);
        g.drawLine(x, middleY, x + arrowSize, middleY + arrowSize);
        g.drawLine(x + w, middleY, x + w - arrowSize, middleY - arrowSize);
        g.drawLine(x + w, middleY, x + w - arrowSize, middleY + arrowSize);
        g.popState();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(-1, 11);
    }
}

