/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.VerticalLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class LifelineVerticalLabel
extends VerticalLabel
implements ILabelFigure {
    private boolean selected;
    private boolean focus;

    public Color getBackgroundColor() {
        if (this.selected) {
            return Display.getDefault().getSystemColor(26);
        }
        return ColorConstants.white;
    }

    public Color getForegroundColor() {
        if (this.selected) {
            return Display.getDefault().getSystemColor(27);
        }
        return super.getForegroundColor();
    }

    public String getText() {
        String text = super.getText();
        return text == null || "".equals(text) ? " " : text;
    }

    public void setIcon(Image icon) {
    }

    public Image getIcon() {
        return null;
    }

    public void setSelected(boolean value) {
        this.selected = value;
        this.setOpaque(value);
        this.updateImage();
    }

    public void setFocus(boolean value) {
        this.focus = value;
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.focus) {
            graphics.drawFocus(this.getBounds().getResized(-1, -1));
        }
    }
}

