/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.eclipse;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.ocl.examples.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.ocl.examples.modelregistry.model.Accessor;
import org.eclipse.ocl.examples.modelregistry.model.ModelNameAccessor;
import org.eclipse.ocl.examples.modelregistry.model.NamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceRegistryReader
extends RegistryReader {
    private static final String TAG_ACCESSOR = "accessor";
    private static final String ATT_CLASS = "class";
    private final NamespaceRegistry namespaceRegistry;

    public NamespaceRegistryReader(NamespaceRegistry namespaceRegistry) {
        super(Platform.getExtensionRegistry(), "org.eclipse.ocl.modelregistry", "namespace");
        this.namespaceRegistry = namespaceRegistry;
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_ACCESSOR)) {
            try {
                this.readElementInternal(element, ModelNameAccessor.NAMESPACE);
            }
            catch (CoreException e) {
                ModelRegistryEnvironment.logError("Failed to load class for '" + element.getAttribute(ATT_CLASS) + "'", e);
                return false;
            }
            return true;
        }
        return false;
    }

    private <A extends Accessor<A>> void readElementInternal(IConfigurationElement element, Accessor.Namespace<A> unusedNamespace) throws CoreException {
        Accessor.Installer accessorInstaller = (Accessor.Installer)element.createExecutableExtension(ATT_CLASS);
        this.namespaceRegistry.addNamespace(accessorInstaller.getNamespace());
    }
}

