/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.listeners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DropTargetListener
extends DiagramDropTargetListener {
    public DropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    protected abstract Object getJavaObject(TransferData var1);

    protected List<EObject> getObjectsBeingDropped() {
        TransferData data = this.getCurrentEvent().currentDataType;
        HashSet<URI> uris = new HashSet<URI>();
        Object transferedObject = this.getJavaObject(data);
        if (transferedObject instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)transferedObject;
            for (Object nextSelectedObject : selection) {
                if (nextSelectedObject instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)nextSelectedObject;
                    nextSelectedObject = adaptable.getAdapter(EObject.class);
                }
                if (!(nextSelectedObject instanceof EObject)) continue;
                EObject modelElement = (EObject)nextSelectedObject;
                Resource modelElementResource = modelElement.eResource();
                uris.add(modelElementResource.getURI().appendFragment(modelElementResource.getURIFragment(modelElement)));
            }
        }
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (URI uri : uris) {
            EObject modelObject = this.getTransactionalEditingDomain().getResourceSet().getEObject(uri, true);
            result.add(modelObject);
        }
        return result;
    }

    protected abstract TransactionalEditingDomain getTransactionalEditingDomain();
}

