/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.statemachine.navigator.UMLAbstractNavigatorItem;
import org.eclipse.papyrus.uml.diagram.statemachine.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.uml.diagram.statemachine.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class UMLNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public UMLNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<UMLNavigatorItem> result = new ArrayList<UMLNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new UMLNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            return result.toArray();
        }
        if (parentElement instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Collection getChildrenByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, String type) {
        ArrayList result = new ArrayList();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    private Collection getIncomingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getLinksSourceByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof UMLAbstractNavigatorItem) {
            UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getViewChildrenForPackageEditPart(view, parentElement);
            }
            case 2000: {
                return this.getViewChildrenForStateMachineEditPart(view, parentElement);
            }
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildrenForPackageEditPart(View view, Object parentElement) {
        ArrayList result = new ArrayList();
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2000));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        return result.toArray();
    }

    private Object[] getViewChildrenForStateMachineEditPart(View view, Object parentElement) {
        ArrayList result = new ArrayList();
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2002));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3000));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        return result.toArray();
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLStateMachineDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }
}

