/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.LinkMappingHelper;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.GeneralizationSet;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileLinkMappingHelper
implements ILinkMappingHelper {
    public static ProfileLinkMappingHelper getInstance() {
        return SingletonHolder.instance;
    }

    private ProfileLinkMappingHelper() {
    }

    public Collection<?> getSource(Element link) {
        return LinkMappingHelper.getSource((Element)link, (LinkMappingHelper.CommonSourceUMLSwitch)new LinkMappingHelper.CommonSourceUMLSwitch(){

            public Collection<?> caseAssociationClass(AssociationClass object) {
                return object.getEndTypes();
            }

            public Collection<?> caseElementImport(ElementImport object) {
                ArrayList<Namespace> result = new ArrayList<Namespace>();
                result.add(object.getImportingNamespace());
                return result;
            }

            public Collection<?> caseGeneralizationSet(GeneralizationSet object) {
                return object.getGeneralizations();
            }

            public Collection<?> caseInterfaceRealization(InterfaceRealization object) {
                ArrayList<BehavioredClassifier> result = new ArrayList<BehavioredClassifier>();
                result.add(object.getImplementingClassifier());
                return result;
            }

            public Collection<?> caseProfileApplication(ProfileApplication object) {
                ArrayList<Package> result = new ArrayList<Package>();
                result.add(object.getApplyingPackage());
                return result;
            }

            public Collection<?> caseTemplateBinding(TemplateBinding object) {
                ArrayList<TemplateableElement> result = new ArrayList<TemplateableElement>();
                result.add(object.getBoundElement());
                return result;
            }

            public Collection<?> caseExtension(Extension object) {
                ArrayList<Type> result = new ArrayList<Type>();
                if (object.getOwnedEnds().size() != 0) {
                    Iterator iterator = object.getOwnedEnds().iterator();
                    while (iterator.hasNext()) {
                        result.add(((Property)iterator.next()).getType());
                    }
                }
                return result;
            }
        });
    }

    public Collection<?> getTarget(Element link) {
        return LinkMappingHelper.getTarget((Element)link, (LinkMappingHelper.CommonTargetUMLSwitch)new LinkMappingHelper.CommonTargetUMLSwitch(){

            public Collection<?> caseExtension(Extension object) {
                ArrayList<Type> result = new ArrayList<Type>();
                if (object.getMemberEnds().size() != 0) {
                    int i = 0;
                    while (i < object.getMemberEnds().size()) {
                        if (!(object.getMemberEnds().get(i) instanceof ExtensionEnd)) {
                            result.add(((Property)object.getMemberEnds().get(i)).getType());
                        }
                        ++i;
                    }
                }
                return result;
            }

            public Collection<?> caseAssociationClass(AssociationClass object) {
                return object.getEndTypes();
            }

            public Collection<?> caseElementImport(ElementImport object) {
                ArrayList<PackageableElement> result = new ArrayList<PackageableElement>();
                result.add(object.getImportedElement());
                return result;
            }

            public Collection<?> caseGeneralizationSet(GeneralizationSet object) {
                return object.getGeneralizations();
            }

            public Collection<?> caseInterfaceRealization(InterfaceRealization object) {
                ArrayList<Interface> result = new ArrayList<Interface>();
                result.add(object.getContract());
                return result;
            }

            public Collection<?> caseProfileApplication(ProfileApplication object) {
                ArrayList<Profile> result = new ArrayList<Profile>();
                result.add(object.getAppliedProfile());
                return result;
            }

            public Collection<?> caseTemplateBinding(TemplateBinding object) {
                return object.getTargets();
            }
        });
    }

    /* synthetic */ ProfileLinkMappingHelper(ProfileLinkMappingHelper profileLinkMappingHelper) {
        this();
    }

    private static class SingletonHolder {
        private static final ProfileLinkMappingHelper instance = new ProfileLinkMappingHelper(null);

        private SingletonHolder() {
        }
    }
}

