/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.ui;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.CloseListener;
import org.eclipse.papyrus.extensionpoints.editors.ui.EmbeddedEditorDocumentProvider;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EmbeddedTextEditor
extends TextEditor {
    protected CloseListener closeListener;
    private ISelectionProvider provider;
    private final IDirectEditorConfiguration directEditorConfiguration;
    private final DiagramCommandStack diagramCommandStack;
    private final TransactionalEditingDomain transactionalEditingDomain;

    public EmbeddedTextEditor(IDirectEditorConfiguration directEditorConfiguration, DiagramCommandStack diagramCommandStack, TransactionalEditingDomain transactionalEditingDomain) {
        this.directEditorConfiguration = directEditorConfiguration;
        this.diagramCommandStack = diagramCommandStack;
        this.transactionalEditingDomain = transactionalEditingDomain;
        this.initialiseSourceViewerConfiguration();
        this.initialiseDocumentProvider();
    }

    public IDirectEditorConfiguration getDirectEditorConfiguration() {
        return this.directEditorConfiguration;
    }

    private void initialiseCompletionListener(SourceViewer sourceViewer) {
        sourceViewer.prependVerifyKeyListener((VerifyKeyListener)new LabelKeyListener(sourceViewer));
        sourceViewer.getControl().addTraverseListener((TraverseListener)new ControlListener(sourceViewer));
    }

    protected void initialiseSourceViewerConfiguration() {
        this.setSourceViewerConfiguration(this.directEditorConfiguration.getSourceViewerConfiguration());
    }

    protected void initialiseDocumentProvider() {
        this.setDocumentProvider((IDocumentProvider)new EmbeddedEditorDocumentProvider(this));
    }

    public void setCloseListener(CloseListener closeListener) {
        this.closeListener = closeListener;
    }

    public void close(boolean save) {
        this.getSite().setSelectionProvider(this.provider);
        this.closeListener.close();
        if (save) {
            ICommandProxy command = new ICommandProxy((ICommand)new AbstractTransactionalCommand(this.transactionalEditingDomain, "Edit property", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    return CommandResult.newOKCommandResult((Object)((EmbeddedEditorDocumentProvider)EmbeddedTextEditor.this.getDocumentProvider()).applyChanges(EmbeddedTextEditor.this.getEditorInput()));
                }
            });
            this.diagramCommandStack.execute((Command)command, (IProgressMonitor)new NullProgressMonitor());
        }
        super.close(false);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SourceViewer viewer = new SourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), 67584);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        this.initialiseCompletionListener(viewer);
        return viewer;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.provider = site.getSelectionProvider();
        super.init(site, input);
    }

    private class ControlListener
    implements TraverseListener {
        SourceViewer viewer;

        public ControlListener(SourceViewer viewer) {
            this.viewer = viewer;
        }

        public void keyTraversed(TraverseEvent e) {
            EmbeddedTextEditor.this.closeListener.keyTraversed(e);
        }
    }

    private class LabelKeyListener
    implements VerifyKeyListener {
        SourceViewer viewer;

        public LabelKeyListener(SourceViewer viewer) {
            this.viewer = viewer;
        }

        public void verifyKey(VerifyEvent event) {
            if (event.stateMask == 262144) {
                block0 : switch (event.character) {
                    case ' ': {
                        this.callOperation(event, 13);
                        break;
                    }
                    case '1': {
                        this.callOperation(event, 22);
                        break;
                    }
                    default: {
                        switch (event.keyCode) {
                            case 122: {
                                this.callOperation(event, 1);
                                break block0;
                            }
                            case 121: {
                                this.callOperation(event, 2);
                                break block0;
                            }
                        }
                        break;
                    }
                }
            } else if (event.character == '\r') {
                EmbeddedTextEditor.this.close(true);
                event.doit = false;
            } else if (event.character == '\u007f' && this.viewer.canDoOperation(6)) {
                this.viewer.doOperation(6);
            }
        }

        private void callOperation(VerifyEvent event, int code) {
            if (this.viewer.canDoOperation(code)) {
                this.viewer.doOperation(code);
            }
            event.doit = false;
        }
    }
}

