/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.extensionpoints.editors.configuration.DefaultDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.definition.DirectEditorExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectEditorsUtil {
    public static IDirectEditorConfiguration findEditorConfiguration(String language, String objectToEdit) {
        DirectEditorExtensionPoint[] extensionPoints;
        DirectEditorExtensionPoint[] directEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            DirectEditorExtensionPoint directEditorExtensionPoint = directEditorExtensionPointArray[n2];
            String lang = directEditorExtensionPoint.getLanguage();
            String oToEdit = directEditorExtensionPoint.getObjectToEdit();
            if (lang.equals(language) && oToEdit.equals(objectToEdit)) {
                return directEditorExtensionPoint.getDirectEditorConfiguration();
            }
            ++n2;
        }
        return new DefaultDirectEditorConfiguration();
    }

    public static boolean hasSpecificEditorConfiguration(String language, String objectToEdit) {
        DirectEditorExtensionPoint[] extensionPoints;
        DirectEditorExtensionPoint[] directEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            DirectEditorExtensionPoint directEditorExtensionPoint = directEditorExtensionPointArray[n2];
            String lang = directEditorExtensionPoint.getLanguage();
            String oToEdit = directEditorExtensionPoint.getObjectToEdit();
            if (lang.equals(language) && oToEdit.equals(objectToEdit)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasSpecificEditorConfiguration(String objectToEdit) {
        DirectEditorExtensionPoint[] extensionPoints;
        DirectEditorExtensionPoint[] directEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            DirectEditorExtensionPoint directEditorExtensionPoint = directEditorExtensionPointArray[n2];
            String oToEdit = directEditorExtensionPoint.getObjectToEdit();
            if (oToEdit.equals(objectToEdit)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List<String> getLanguages(String objectToEdit) {
        DirectEditorExtensionPoint[] extensionPoints;
        ArrayList<String> languages = new ArrayList<String>();
        DirectEditorExtensionPoint[] directEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            String lang;
            DirectEditorExtensionPoint directEditorExtensionPoint = directEditorExtensionPointArray[n2];
            if ((objectToEdit == null || directEditorExtensionPoint.getObjectToEdit().equals(objectToEdit)) && !languages.contains(lang = directEditorExtensionPoint.getLanguage())) {
                languages.add(lang);
            }
            ++n2;
        }
        return languages;
    }
}

