/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.ocl.examples.eventmanager.CompositeIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeCollection<E>
extends CompositeIterable<E>
implements Collection<E> {
    private int size = -1;

    public CompositeCollection(Collection<? extends E> ... collections) {
        super(collections);
    }

    public CompositeCollection(Collection<Iterable<? extends E>> collections) {
        super(collections);
    }

    private Collection<? extends E>[] getCollections() {
        return (Collection[])this.getIterables();
    }

    @Override
    public boolean contains(Object o) {
        Collection<E>[] collectionArray = this.getCollections();
        int n = collectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<E> collection = collectionArray[n2];
            if (collection.contains(o)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Unmodifiable collection");
    }

    @Override
    public boolean add(E e) {
        throw new RuntimeException("Unmodifiable collection");
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException("Unmodifiable collection");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new RuntimeException("Unmodifiable collection");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Unmodifiable collection");
    }

    @Override
    public void clear() {
        throw new RuntimeException("Unmodifiable collection");
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int nextSet = 0;
            private Iterator<? extends E> iter = this.nextIter();

            @Override
            public boolean hasNext() {
                return this.iter != null && this.iter.hasNext();
            }

            private Iterator<? extends E> nextIter() {
                Iterator result = null;
                while (!(this.nextSet >= CompositeCollection.this.getCollections().length || result != null && result.hasNext())) {
                    result = CompositeCollection.this.getCollections()[this.nextSet++].iterator();
                }
                return result;
            }

            @Override
            public E next() {
                Object result = this.iter.next();
                if (!this.iter.hasNext()) {
                    this.iter = this.nextIter();
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read-only iterator on composite set");
            }
        };
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Collection<E>[] collectionArray = this.getCollections();
            int n = collectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Collection<E> s = collectionArray[n2];
                this.size += s.size();
                ++n2;
            }
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        Collection<E>[] collectionArray = this.getCollections();
        int n = collectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<E> s = collectionArray[n2];
            if (!s.isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (E o : this) {
            result[i++] = o;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] result = new Object[this.size()];
        int i = 0;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            E o;
            E to = o = iterator.next();
            result[i++] = to;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }
}

