/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.Activator;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTypeUtils {
    private ElementTypeUtils() {
    }

    public static final Collection<IElementType> getAllExistingElementTypes() {
        IClientContext clientContext = null;
        try {
            clientContext = TypeContext.getContext();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        IElementType[] types = ElementTypeRegistry.getInstance().getElementTypes(clientContext);
        return Arrays.asList(types);
    }

    public static final Collection<String> getAllExistingElementTypesIds() {
        TreeSet<String> ids = new TreeSet<String>();
        for (IElementType iElementType : ElementTypeUtils.getAllExistingElementTypes()) {
            ids.add(iElementType.getId());
        }
        return ids;
    }
}

