/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.providers;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Profile;

public class AppliedProfileLabelProvider
extends StyledCellLabelProvider {
    private final ILabelProvider umlLabelProvider = new UMLLabelProvider();

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int columnIndex = cell.getColumnIndex();
        StyledString styledText = this.getStyledText(element, columnIndex);
        cell.setText(styledText.getString());
        cell.setStyleRanges(styledText.getStyleRanges());
        cell.setImage(this.getImage(element, columnIndex));
    }

    protected StyledString getStyledText(Object element, int columnIndex) {
        if (columnIndex == 1 && element instanceof Profile) {
            Profile profile = (Profile)element;
            StyledString styledString = new StyledString(profile.getQualifiedName());
            return styledString;
        }
        return new StyledString(this.getText(element, columnIndex));
    }

    protected String getText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.umlLabelProvider.getText(element);
            }
            case 1: {
                if (!(element instanceof Profile)) break;
                return ((Profile)element).getQualifiedName();
            }
        }
        return "";
    }

    protected Image getImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.umlLabelProvider.getImage(element);
            }
            case 1: {
                if (!(element instanceof Profile)) break;
                return this.umlLabelProvider.getImage(element);
            }
        }
        return null;
    }
}

