/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.internal.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecoretools.filters.internal.FilterPlugin;
import org.eclipse.emf.ecoretools.filters.internal.Messages;
import org.eclipse.emf.ecoretools.filters.internal.commands.FilterDiagramCommand;
import org.eclipse.emf.ecoretools.filters.internal.utils.DiagramFilterUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ApplyFilterDiagramAction
extends Action {
    protected IGraphicalEditPart host;
    public static String ID = "applyFilterDiagramAction";

    public ApplyFilterDiagramAction() {
        this.setId(ID);
        this.setText(Messages.ApplyFilterDiagramAction_ApplyFilter);
        this.setToolTipText(Messages.ApplyFilterDiagramAction_ApplyFilter_tooltip);
        this.setImageDescriptor(FilterPlugin.getImageDescriptor("icons/etool16/applyfilter_exec.gif"));
        this.updateImageDescriptor(this.getCurrentDiagram());
    }

    private Diagram getCurrentDiagram() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof DiagramEditor)) {
            return null;
        }
        this.host = ((DiagramEditor)editorPart).getDiagramEditPart();
        if (!(this.host instanceof IGraphicalEditPart)) {
            return null;
        }
        View view = (View)this.host.getModel();
        Diagram diagram = view.getDiagram();
        return diagram;
    }

    public void run() {
        Diagram diagram = this.getCurrentDiagram();
        if (diagram == null) {
            return;
        }
        ICommandProxy cmd = new ICommandProxy((ICommand)new FilterDiagramCommand(this.host.getEditingDomain(), diagram, DiagramFilterUtil.getCurrentFilteredTypeConfiguration(diagram), false));
        DiagramCommandStack commandStack = this.host.getDiagramEditDomain().getDiagramCommandStack();
        commandStack.execute((Command)cmd, (IProgressMonitor)new NullProgressMonitor());
        this.updateImageDescriptor(diagram);
    }

    private void updateImageDescriptor(Diagram diagram) {
        if (diagram == null) {
            this.setChecked(false);
        }
        if (DiagramFilterUtil.isDiagramFiltered(diagram)) {
            this.setChecked(true);
        } else {
            this.setChecked(false);
        }
    }
}

