/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.AbstractOperationFilter;

public class ImplicitCollectFilter
extends AbstractOperationFilter {
    @NonNull
    protected final Type iteratorType;

    public ImplicitCollectFilter(@NonNull CollectionType sourceType, @NonNull Type iteratorType) {
        super((Type)sourceType);
        this.iteratorType = iteratorType;
    }

    public boolean matches(@NonNull EnvironmentView environmentView, @NonNull DomainElement eObject) {
        if (!(eObject instanceof Iteration)) {
            return false;
        }
        Iteration candidateIteration = (Iteration)eObject;
        int iteratorCount = candidateIteration.getOwnedIterator().size();
        if (iteratorCount != 1) {
            return false;
        }
        int accumulatorCount = candidateIteration.getOwnedAccumulator().size();
        if (accumulatorCount != 0) {
            return false;
        }
        TemplateSignature templateSignature = candidateIteration.getOwningType().getOwnedTemplateSignature();
        if (templateSignature == null) {
            return false;
        }
        List templateParameters = templateSignature.getOwnedParameter();
        if (templateParameters.size() != 1) {
            return false;
        }
        Map bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, (TemplateableElement)this.sourceType);
        TemplateParameter iteratorParameter = (TemplateParameter)templateParameters.get(0);
        if (bindings != null) {
            bindings.put(iteratorParameter, this.iteratorType);
        }
        this.installBindings(environmentView, eObject, bindings);
        return true;
    }
}

