/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.AbstractNameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;

public class NavigationUtil {
    @Nullable
    public static NavigationOperatorCS getNavigationOperator(@NonNull AbstractNameExpCS csExp) {
        EObject eContainer = csExp.eContainer();
        if (eContainer instanceof AbstractNameExpCS) {
            csExp = (AbstractNameExpCS)eContainer;
        }
        ExpCS csChild = csExp;
        OperatorCS csOperator;
        while ((csOperator = csChild.getParent()) != null) {
            ExpCS csSource = csOperator.getSource();
            if (csSource != csChild) {
                if (csOperator instanceof NavigationOperatorCS) {
                    return (NavigationOperatorCS)csOperator;
                }
                return null;
            }
            csChild = csChild.getParent();
        }
        return null;
    }

    @Nullable
    public static Type getNavigationSourceType(@NonNull MetaModelManager metaModelManager, @NonNull NavigationOperatorCS csOperator) {
        ExpCS csSource = csOperator.getSource();
        if (csSource == null) {
            return null;
        }
        OCLExpression source = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csSource);
        if (source == null) {
            return null;
        }
        Type type = source.getType();
        if (type == null) {
            return null;
        }
        String opName = csOperator.getName();
        if (opName.equals("->")) {
            if (type instanceof CollectionType) {
                return type;
            }
            return metaModelManager.getCollectionType(false, true, type, null, null);
        }
        if (type instanceof CollectionType) {
            while (type instanceof CollectionType) {
                type = ((CollectionType)type).getElementType();
            }
            return type;
        }
        return type;
    }

    public static boolean isIteration(@NonNull MetaModelManager metaModelManager, @NonNull InvocationExpCS csInvocationExp, @NonNull CollectionType type) {
        for (NavigatingArgCS csArg : csInvocationExp.getArgument()) {
            if (csArg.getRole() == NavigationRole.EXPRESSION) continue;
            return true;
        }
        PathNameCS pathName = csInvocationExp.getPathName();
        EList path = pathName.getPath();
        if (path.size() != 1) {
            return false;
        }
        PathElementCS csPathElement = (PathElementCS)path.get(0);
        Element unresolvedElement = csPathElement.basicGetElement();
        if (unresolvedElement != null && !unresolvedElement.eIsProxy()) {
            return unresolvedElement instanceof Iteration;
        }
        String name = csPathElement.toString();
        assert (name != null);
        Iterator iterator = metaModelManager.getAllOperations((DomainType)type, false, name).iterator();
        if (iterator.hasNext()) {
            DomainOperation operation = (DomainOperation)iterator.next();
            return operation instanceof Iteration;
        }
        return false;
    }
}

