/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.pivot2cs;

import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTFactory;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TupleTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseReferenceVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CSConversion;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.EssentialOCLCSTFactory;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TypeNameExpCS;

public class EssentialOCLReferenceVisitor
extends BaseReferenceVisitor {
    public static final Logger logger = Logger.getLogger(BaseReferenceVisitor.class);

    public EssentialOCLReferenceVisitor(@NonNull Pivot2CSConversion context) {
        super(context);
    }

    public ElementCS visitClass(@NonNull Class object) {
        return this.visitType((Type)object);
    }

    public ElementCS visitCollectionType(@NonNull CollectionType object) {
        CollectionTypeCS csRef = EssentialOCLCSTFactory.eINSTANCE.createCollectionTypeCS();
        csRef.setPivot((Element)object);
        csRef.setName(object.getName());
        Type elementType = object.getElementType();
        if (elementType != null) {
            csRef.setOwnedType((TypedRefCS)elementType.accept((Visitor)this));
            Package typePackage = elementType.getPackage();
            if (typePackage != null) {
                ((Pivot2CSConversion)this.context).importNamespace((Namespace)typePackage, null);
            }
        }
        return csRef;
    }

    public ElementCS visitPrimitiveType(@NonNull PrimitiveType object) {
        PrimitiveTypeRefCS csRef = BaseCSTFactory.eINSTANCE.createPrimitiveTypeRefCS();
        csRef.setPivot((Element)object);
        csRef.setName(object.getName());
        return csRef;
    }

    public ElementCS visitTupleType(@NonNull TupleType object) {
        TupleTypeCS csRef = BaseCSTFactory.eINSTANCE.createTupleTypeCS();
        csRef.setPivot((Element)object);
        return csRef;
    }

    public ElementCS visitType(@NonNull Type object) {
        TypeNameExpCS csRef = EssentialOCLCSTFactory.eINSTANCE.createTypeNameExpCS();
        csRef.setPivot((Element)object);
        PathNameCS csPathName = csRef.getPathName();
        if (csPathName == null) {
            csPathName = BaseCSTFactory.eINSTANCE.createPathNameCS();
            assert (csPathName != null);
            csRef.setPathName(csPathName);
        }
        ((Pivot2CSConversion)this.context).refreshPathName(csPathName, (Element)object, null);
        Package typePackage = object.getPackage();
        if (typePackage != null) {
            ((Pivot2CSConversion)this.context).importNamespace((Namespace)typePackage, null);
        }
        return csRef;
    }
}

