/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.utilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.LibraryDiagnostic;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CS;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.EssentialOCLCS2Pivot;
import org.eclipse.ocl.examples.xtext.essentialocl.pivot2cs.EssentialOCLPivot2CS;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.util.CancelIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCSResource
extends LazyLinkingResource
implements BaseCSResource {
    @Nullable
    private ParserContext parserContext = null;

    protected void addLibraryError(List<Resource.Diagnostic> errors, IllegalLibraryException e) {
        String message = e.getMessage();
        for (Resource.Diagnostic diagnostic : errors) {
            Exception exception;
            if (!(diagnostic instanceof LibraryDiagnostic) || !((exception = ((LibraryDiagnostic)diagnostic).getException()) instanceof IllegalLibraryException) || !message.equals(exception.getMessage())) continue;
            return;
        }
        errors.add((Resource.Diagnostic)new LibraryDiagnostic((Exception)((Object)e)));
    }

    protected void addSyntaxErrors() {
        if (this.isValidationDisabled()) {
            return;
        }
        IParseResult parseResult = this.getParseResult();
        if (parseResult == null) {
            return;
        }
        EList errors2 = this.getErrors();
        for (final INode error : parseResult.getSyntaxErrors()) {
            String tokenText;
            int index;
            String message;
            Object diagnostic = null;
            final SyntaxErrorMessage syntaxErrorMessage = error.getSyntaxErrorMessage();
            if (syntaxErrorMessage != null && (message = syntaxErrorMessage.getMessage()) != null && (index = message.indexOf("<EOF>")) >= 0 && (tokenText = NodeModelUtils.getTokenText((INode)error)) != null) {
                final String newMessage = String.valueOf(message.substring(0, index)) + tokenText + message.substring(index + 5);
                diagnostic = new AbstractDiagnostic(){

                    public String getMessage() {
                        return newMessage;
                    }

                    protected INode getNode() {
                        return error;
                    }

                    public String getCode() {
                        return syntaxErrorMessage.getIssueCode();
                    }

                    public String[] getData() {
                        return syntaxErrorMessage.getIssueData();
                    }
                };
            }
            if (diagnostic == null) {
                diagnostic = new XtextSyntaxDiagnostic(error);
            }
            errors2.add(diagnostic);
        }
    }

    @NonNull
    public CS2Pivot createCS2Pivot(@NonNull Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, @NonNull MetaModelManager metaModelManager) {
        return new EssentialOCLCS2Pivot(cs2pivotResourceMap, metaModelManager);
    }

    public Pivot2CS createPivot2CS(@NonNull Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, @NonNull MetaModelManager metaModelManager) {
        return new EssentialOCLPivot2CS(cs2pivotResourceMap, metaModelManager);
    }

    @NonNull
    public MetaModelManager createMetaModelManager() {
        MetaModelManagerResourceSetAdapter resourceSetAdapter;
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null && (resourceSetAdapter = MetaModelManagerResourceSetAdapter.findAdapter((ResourceSet)resourceSet)) != null) {
            return resourceSetAdapter.getMetaModelManager();
        }
        return new MetaModelManager();
    }

    protected void doLinking() {
        EList errors = this.getErrors();
        if (errors.size() > 0) {
            int i = errors.size();
            while (--i >= 0) {
                Resource.Diagnostic error = (Resource.Diagnostic)errors.get(i);
                if (!(error instanceof LibraryDiagnostic)) continue;
                errors.remove(i);
            }
        }
        super.doLinking();
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        super.doLoad(inputStream, options);
    }

    @NonNull
    public String getEditorName() {
        return "Essential OCL";
    }

    @Nullable
    public ParserContext getParserContext() {
        return this.parserContext;
    }

    @NonNull
    public Resource getPivotResource(@Nullable MetaModelManager metaModelManager) {
        CS2PivotResourceAdapter adapter = CS2PivotResourceAdapter.getAdapter((BaseCSResource)this, (MetaModelManager)metaModelManager);
        Resource pivotResource = adapter.getPivotResource((BaseCSResource)this);
        if (pivotResource == null) {
            throw new IllegalStateException("No Pivot Resource created");
        }
        return pivotResource;
    }

    @NonNull
    public URI resolve(@NonNull URI uri) {
        URI csURI = this.getURI();
        if (csURI.isRelative()) {
            File csRelative = new File(csURI.toFileString());
            File csAbsolute = csRelative.getAbsoluteFile();
            csURI = URI.createFileURI((String)csAbsolute.toString());
        }
        URI resolvedURI = uri.resolve(csURI);
        assert (resolvedURI != null);
        return resolvedURI;
    }

    public void resolveLazyCrossReferences(CancelIndicator mon) {
        EList errors = this.getErrors();
        assert (errors != null);
        if (ElementUtil.hasSyntaxError((List)errors)) {
            return;
        }
        MetaModelManager metaModelManager = PivotUtil.findMetaModelManager((Resource)this);
        if (metaModelManager != null) {
            try {
                metaModelManager.getOclAnyType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclElementType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclVoidType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclInvalidType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getMetaclassType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getBooleanType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getRealType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getIntegerType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getUnlimitedNaturalType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getStringType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getCollectionType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getBagType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getSequenceType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getSetType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOrderedSetType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getEnumerationType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclTupleType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                metaModelManager.getOclLambdaType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
        }
        super.resolveLazyCrossReferences(mon);
    }

    public void setParserContext(@Nullable ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public void updateFrom(@NonNull Resource pivotResource, @NonNull MetaModelManager metaModelManager) {
        HashMap<EssentialOCLCSResource, Resource> cs2PivotResourceMap = new HashMap<EssentialOCLCSResource, Resource>();
        cs2PivotResourceMap.put(this, pivotResource);
        Pivot2CS pivot2cs = this.createPivot2CS(cs2PivotResourceMap, metaModelManager);
        pivot2cs.update();
    }
}

