/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.uml.profile.definition.Version;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileTreeSelectionDialog;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.papyrus.uml.profile.validation.ProfileValidationHelper;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.messages.Messages;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.Message;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.RegisteredProfileSelectionDialog;
import org.eclipse.papyrus.uml.tools.importsources.PackageImportSourceDialog;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ProfileApplicationEditor
extends MultipleReferenceEditor {
    protected Button addRegisteredProfile;
    protected Button reapplyProfile;
    protected Package umlPackage;

    public ProfileApplicationEditor(Composite parent, int style) {
        super(parent, style);
        this.tree.setHeaderVisible(true);
        GridData treeData = new GridData(4, 4, true, true);
        treeData.horizontalSpan = 2;
        treeData.minimumHeight = 140;
        this.tree.setLayoutData((Object)treeData);
        TableLayout layout = new TableLayout(true);
        this.tree.setLayout((Layout)layout);
        TreeColumn nameColumn = new TreeColumn(this.tree, 0);
        nameColumn.setText("Name");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, 400, true));
        TreeColumn locationColumn = new TreeColumn(this.tree, 0);
        locationColumn.setText("Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 300, true));
        TreeColumn versionColumn = new TreeColumn(this.tree, 0);
        versionColumn.setText("Version");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 100, true));
    }

    public void setToolTipText(String text) {
        super.setLabelToolTipText(text);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        super.setLabelProvider((ILabelProvider)new ProfileColumnsLabelProvider(labelProvider));
    }

    protected void createListControls() {
        super.createListControls();
        this.up.dispose();
        this.down.dispose();
        this.edit.dispose();
        this.edit = null;
        this.down = null;
        this.up = null;
        this.add.setToolTipText(Messages.ProfileApplicationEditor_ApplyProfile);
        this.addRegisteredProfile = this.createButton(Activator.getDefault().getImage("/icons/AddReg.gif"), Messages.ProfileApplicationEditor_ApplyRegisteredProfile);
        this.reapplyProfile = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/refresh.gif"), "Reapply profile");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProfileApplicationEditor.this.updateControls();
            }
        });
    }

    protected void addAction() {
        LinkedHashMap<String, String> extensionFilters = new LinkedHashMap<String, String>();
        extensionFilters.put("*.profile.uml", "UML Profiles (*.profile.uml)");
        extensionFilters.put("*.uml", "UML (*.uml)");
        extensionFilters.put("*", "All (*)");
        Collection packages = PackageImportSourceDialog.open((Shell)this.getShell(), (String)Messages.ProfileApplicationEditor_ApplyProfilesDialogTitle, Collections.singletonList(this.umlPackage), extensionFilters);
        if (packages == null || packages.isEmpty()) {
            return;
        }
        if (packages.size() > 0) {
            ProfileTreeSelectionDialog profileDialog = new ProfileTreeSelectionDialog(this.getShell(), packages);
            if (profileDialog.open() != 0) {
                return;
            }
            if (profileDialog.getResult().isEmpty()) {
                return;
            }
            Collection profilesImportToApply = profileDialog.getResult();
            LinkedList<Profile> profilesToApply = new LinkedList<Profile>();
            for (ElementImportTreeSelectionDialog.ImportSpec importProfile : profilesImportToApply) {
                profilesToApply.add((Profile)importProfile.getElement());
            }
            if (!ProfileValidationHelper.checkApplicableProfiles((Shell)this.getShell(), profilesToApply)) {
                return;
            }
            Message message = new Message(Messages.ProfileApplicationEditor_WaitMessageTitle, Messages.ProfileApplicationEditor_WaitMessage);
            message.open();
            for (Profile profile : profilesToApply) {
                this.modelProperty.add((Object)profile);
            }
            message.close();
            this.commit();
        }
    }

    protected void addRegisteredAction() {
        RegisteredProfileSelectionDialog profileSelectionDialog = new RegisteredProfileSelectionDialog((Composite)this.getShell(), this.umlPackage);
        List<Profile> profilesToApply = profileSelectionDialog.run();
        for (Profile profile : profilesToApply) {
            this.modelProperty.add((Object)profile);
        }
        this.commit();
    }

    protected void reapplyProfileAction() {
        ISelection selectedElements = this.treeViewer.getSelection();
        LinkedList<Profile> profilesToRefresh = new LinkedList<Profile>();
        if (!selectedElements.isEmpty() && selectedElements instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)selectedElements;
            for (Object element : selection) {
                if (!(element instanceof Profile)) continue;
                profilesToRefresh.add((Profile)element);
            }
        }
        if (ProfileValidationHelper.checkApplicableProfiles((Shell)this.getShell(), profilesToRefresh)) {
            for (Profile profile : profilesToRefresh) {
                this.modelProperty.add((Object)profile);
            }
            this.commit();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.widget == this.addRegisteredProfile) {
            this.addRegisteredAction();
        }
        if (e.widget == this.reapplyProfile) {
            this.reapplyProfileAction();
        }
    }

    public void setPackage(Package umlPackage) {
        this.umlPackage = umlPackage;
        this.updateControls();
    }

    protected void updateControls() {
        boolean enabled = this.modelProperty != null && this.umlPackage != null;
        this.add.setEnabled(enabled);
        this.addRegisteredProfile.setEnabled(enabled);
        this.remove.setEnabled(enabled);
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        enabled = false;
        for (Object element : selection) {
            if (!(element instanceof Profile) || !ProfileUtil.isDirty((Package)this.umlPackage, (Profile)((Profile)element))) continue;
            enabled = true;
            break;
        }
        this.reapplyProfile.setEnabled(enabled);
    }

    protected class ProfileColumnsLabelProvider
    extends ColumnLabelProvider {
        private ILabelProvider defaultLabelProvider;

        public ProfileColumnsLabelProvider(ILabelProvider defaultLabelProvider) {
            this.defaultLabelProvider = defaultLabelProvider;
        }

        public void update(ViewerCell cell) {
            if (cell.getColumnIndex() == 0) {
                this.updateName(cell);
                return;
            }
            EObject element = EMFHelper.getEObject((Object)cell.getElement());
            if (!(element instanceof Profile)) {
                cell.setText("");
                return;
            }
            Profile profile = (Profile)element;
            switch (cell.getColumnIndex()) {
                case 1: {
                    this.updateLocation(cell, profile);
                    break;
                }
                case 2: {
                    this.updateVersion(cell, profile);
                }
            }
        }

        public void updateName(ViewerCell cell) {
            cell.setImage(this.defaultLabelProvider.getImage(cell.getElement()));
            cell.setText(this.defaultLabelProvider.getText(cell.getElement()));
        }

        public void updateLocation(ViewerCell cell, Profile profile) {
            URI uri;
            String location = "Unknown";
            if (profile.eResource() != null && (uri = profile.eResource().getURI()) != null) {
                location = uri.toString();
            }
            cell.setText(location);
        }

        public void updateVersion(ViewerCell cell, Profile profile) {
            String versionText = "";
            Version version = Util.getProfileDefinitionVersion((Profile)profile);
            if (version != Version.emptyVersion) {
                versionText = version.toString();
            }
            cell.setText(versionText);
        }
    }
}

