/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.DynamicModelWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.ui.OCLPropertyTester;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class CreateDynamicInstanceHandler
extends AbstractHandler {
    protected static final URI PLATFORM_RESOURCE = URI.createPlatformResourceURI((String)"/", (boolean)false);
    private Class selectedClass = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedClass != null) {
            EObject eTarget = this.selectedClass.getETarget();
            EClass selectedEClass = null;
            if (eTarget instanceof EClass) {
                selectedEClass = (EClass)eTarget;
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (selectedEClass != null) {
                IFile file;
                URI uri = selectedEClass.eResource().getURI();
                StructuredSelection selection = StructuredSelection.EMPTY;
                if (uri.isHierarchical() && (uri.isRelative() || (uri = uri.deresolve(PLATFORM_RESOURCE)).isRelative()) && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toString()))).exists()) {
                    selection = new StructuredSelection((Object)file);
                }
                DynamicModelWizard dynamicModelWizard = new DynamicModelWizard(selectedEClass);
                dynamicModelWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)dynamicModelWizard);
                wizardDialog.open();
            } else {
                MessageDialog.openError((Shell)shell, (String)"Create Dynamic Instance", (String)("No Ecore prototype found for '" + this.selectedClass.getName() + "'\nPlease Save as Ecore and Re-open."));
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return this.selectedClass != null && super.isEnabled();
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext evalContext;
        XtextEditor xtextEditor;
        this.selectedClass = null;
        if (evaluationContext instanceof IEvaluationContext && (xtextEditor = OCLPropertyTester.getActiveXtextEditor((IEvaluationContext)(evalContext = (IEvaluationContext)evaluationContext))) != null) {
            final ITextSelection selection = (ITextSelection)xtextEditor.getSelectionProvider().getSelection();
            IXtextDocument document = xtextEditor.getDocument();
            this.selectedClass = (Class)document.readOnly((IUnitOfWork)new IUnitOfWork<Class, XtextResource>(){

                public Class exec(XtextResource xtextResource) {
                    if (xtextResource == null) {
                        return null;
                    }
                    IParseResult parseResult = xtextResource.getParseResult();
                    if (parseResult == null) {
                        throw new NullPointerException("parseResult is null");
                    }
                    ICompositeNode rootNode = parseResult.getRootNode();
                    ILeafNode lastVisibleNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)selection.getOffset());
                    if (lastVisibleNode == null) {
                        return null;
                    }
                    EObject currentModel = NodeModelUtils.findActualSemanticObjectFor((INode)lastVisibleNode);
                    if (!(currentModel instanceof ClassCS)) {
                        return null;
                    }
                    ClassCS oclInEcoreClass = (ClassCS)currentModel;
                    return (Class)PivotUtil.getPivot(Class.class, (Pivotable)oclInEcoreClass);
                }
            });
        }
    }
}

