/**
 * <copyright>
 *
 * Copyright (c) 2010, 2012 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *
 * </copyright>
 *
 * $Id: EssentialOCLQuickfixProvider.java,v 1.1 2010/04/13 06:33:11 ewillink Exp $
 */
package org.eclipse.ocl.examples.xtext.essentialocl.ui.quickfix;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.validation.Issue;

public class EssentialOCLQuickfixProvider extends ExtensibleQuickfixProvider
{
	private static final Logger logger = Logger.getLogger(EssentialOCLQuickfixProvider.class);

	protected class EssentialOCLQuickfixProcessor extends QuickfixProcessor
	{
		public EssentialOCLQuickfixProcessor(IXtextDocument xtextDocument, Issue issue,
				IssueResolutionAcceptor issueResolutionAcceptor) {
			super(xtextDocument, issue, issueResolutionAcceptor);
		}

		@Override
		public void createResolution(String issueString, IEObjectDescription solution, String ruleName, Keyword keyword, boolean caseInsensitive) {
			String replacement = qualifiedNameConverter.toString(solution.getName());
			String replaceLabel = fixCrossReferenceLabel(issueString, replacement);
			EObject eObjectOrProxy = solution.getEObjectOrProxy();
			if (eObjectOrProxy instanceof Element) {
				replaceLabel += " - " + PrettyPrinter.print((Element) eObjectOrProxy);
			}
			if (keyword != null) {
				if (caseInsensitive && !replacement.equalsIgnoreCase(keyword.getValue()))
					return;
				if (!caseInsensitive && !replacement.equals(keyword.getValue()))
					return;
			} else if (ruleName != null) {
				replacement = valueConverter.toString(replacement, ruleName);
			} else {
				logger.error("either keyword or ruleName have to present", new IllegalStateException());
			}
			issueResolutionAcceptor.accept(issue, replaceLabel, replaceLabel, fixCrossReferenceImage(
					issueString, replacement), new ReplaceModification(issue, replacement));
		}
	}
	@Override
	protected QuickfixProcessor createQuickfixProcessor(IXtextDocument xtextDocument,
			Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
		return new EssentialOCLQuickfixProcessor(xtextDocument, issue, issueResolutionAcceptor);
	}
}
