/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.compare;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.core.compare.CapellaScope;

public class CapellaComparePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.polarsys.capella.core.compare";
    private static CapellaComparePlugin plugin;
    protected static final String CC_PROJECT_NATURE = "com.rational.clearcase.ccprovider_nature";
    protected final Map<CapellaScope, IProject> proxyProjects = new HashMap<CapellaScope, IProject>();

    public void cleanupProxyProjects() {
        for (IProject proxyProject : this.proxyProjects.values()) {
            try {
                RepositoryProvider.unmap((IProject)proxyProject);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            try {
                proxyProject.delete(true, true, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static CapellaComparePlugin getDefault() {
        return plugin;
    }

    public IProject getProxyProject(CapellaScope scope, IPath externalFilePath) {
        IWorkspace wk;
        IProject result = this.proxyProjects.get((Object)scope);
        if (result == null && (wk = ResourcesPlugin.getWorkspace()) != null && wk.getRoot() != null) {
            result = wk.getRoot().getProject("DiffMergeExternalFiles_" + System.identityHashCode((Object)scope));
            try {
                if (!result.exists()) {
                    result.create(null);
                }
                if (!result.isOpen()) {
                    result.open(null);
                }
                this.forceClearCaseNature(result, externalFilePath);
                this.proxyProjects.put(scope, result);
            }
            catch (TeamException teamException) {
            }
            catch (CoreException e) {
                result = null;
            }
        }
        return result;
    }

    protected boolean forceClearCaseNature(IProject project, IPath referencePath) {
        boolean result = false;
        try {
            RepositoryProvider.map((IProject)project, (String)CC_PROJECT_NATURE);
            ProxyProjectWrapper wrapper = new ProxyProjectWrapper(project, referencePath);
            Bundle ccBundle = Platform.getBundle((String)"com.rational.clearcase");
            Class ccClass = ccBundle.loadClass("com.rational.clearcase.ClearCasePlugin");
            Class srvClass = ccBundle.loadClass("com.rational.clearcase.RSCMService");
            Object service = ccClass.getMethod("getCMService", new Class[0]).invoke(null, new Object[0]);
            Object eval = srvClass.getMethod("connectProject", IProject.class).invoke(service, new Object[]{wrapper});
            result = eval instanceof Boolean && (Boolean)eval != false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.cleanupProxyProjects();
    }

    protected static class ProxyProjectWrapper
    extends Project {
        private final IProject wrappedProject;
        private final IPath specificLocation;

        public ProxyProjectWrapper(IProject wrappedProjectParam, IPath specificLocationParam) {
            super(wrappedProjectParam.getFullPath(), (Workspace)wrappedProjectParam.getWorkspace());
            this.wrappedProject = wrappedProjectParam;
            this.specificLocation = specificLocationParam;
        }

        public IPath getLocation() {
            return this.specificLocation;
        }

        public IProject getWrappedProject() {
            return this.wrappedProject;
        }

        public boolean equals(Object peer) {
            boolean result = false;
            if (peer instanceof ProxyProjectWrapper) {
                result = ((ProxyProjectWrapper)((Object)peer)).getWrappedProject().equals((Object)this.getWrappedProject());
            } else if (peer instanceof IProject) {
                result = ((IProject)peer).equals((Object)this.getWrappedProject());
            }
            return result;
        }

        public int hashCode() {
            return this.getWrappedProject().hashCode();
        }
    }
}

