/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.ide.undo.MoveResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;

public class RenameResourceAction
extends WorkspaceAction {
    private static final String AND_HTML_REPRESENTATION = "&amp;";
    private static final String CAPELLA_PROJECT_NAME_ATT = "name=\"";
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private TreeEditor treeEditor;
    private Tree navigatorTree;
    private Text textEditor;
    private Composite textEditorParent;
    private TextActionHandler textActionHandler;
    private IResource inlinedResource;
    private boolean saving = false;
    public static final String ID = "org.eclipse.ui.RenameResourceAction";
    private IPath newPath;
    private String[] modelProviderIds;
    private Shell _shell;
    private static final String CHECK_RENAME_TITLE = IDEWorkbenchMessages.RenameResourceAction_checkTitle;
    private static final String CHECK_RENAME_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_readOnlyCheck;
    private static String RESOURCE_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_resourceExists;
    private static String RESOURCE_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteQuestion;
    private static String PROJECT_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteProjectQuestion;
    private static String PROJECT_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_projectExists;

    public RenameResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.RenameResourceAction_text);
        this.setToolTipText(IDEWorkbenchMessages.RenameResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.rename_resource_action_context");
        this._shell = shell;
    }

    public RenameResourceAction(Shell shell, Tree tree) {
        this(shell);
        this.navigatorTree = tree;
        this.treeEditor = new TreeEditor(tree);
    }

    private boolean checkOverwrite(final Shell shell, final IResource destination) {
        final boolean[] result = new boolean[1];
        Runnable query = new Runnable(){

            @Override
            public void run() {
                String pathName = destination.getFullPath().makeRelative().toString();
                String message = RESOURCE_EXISTS_MESSAGE;
                String title = RESOURCE_EXISTS_TITLE;
                if (destination.getType() == 4) {
                    message = PROJECT_EXISTS_MESSAGE;
                    title = PROJECT_EXISTS_TITLE;
                }
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)MessageFormat.format(message, pathName));
            }
        };
        shell.getDisplay().syncExec(query);
        return result[0];
    }

    private boolean checkReadOnlyAndNull(IResource currentResource) {
        if (currentResource == null) {
            return false;
        }
        ResourceAttributes attributes = currentResource.getResourceAttributes();
        if (attributes != null && attributes.isReadOnly()) {
            return MessageDialog.openQuestion((Shell)this._shell, (String)CHECK_RENAME_TITLE, (String)MessageFormat.format(CHECK_RENAME_MESSAGE, currentResource.getName()));
        }
        return true;
    }

    protected IRunnableWithProgress createOperation(final IStatus[] errorStatus) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                final IResource[] resources = RenameResourceAction.this.getActionResources().toArray(new IResource[RenameResourceAction.this.getActionResources().size()]);
                if (!SessionManager.INSTANCE.getSessions().isEmpty()) {
                    RenameResourceAction.this._shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)RenameResourceAction.this._shell, (String)Messages.RenameResourceAction_Session_Warning_Dialog_Title, (String)NLS.bind((String)Messages.RenameResourceAction_Session_Warning_Dialog_Message, (Object)resources[0].getName()));
                        }
                    });
                    return;
                }
                if (resources.length == 1) {
                    IResource oldResource = resources[0];
                    RenameResourceAction.this.renameResource(oldResource, RenameResourceAction.this.newPath, monitor, errorStatus);
                    if ("aird".equals(oldResource.getFileExtension())) {
                        IPath oldAfmPath = RenameResourceAction.this.changeExtension(oldResource.getFullPath(), "afm");
                        IWorkspaceRoot workspaceRoot = oldResource.getWorkspace().getRoot();
                        IResource oldAfmResource = workspaceRoot.findMember(oldAfmPath);
                        if (oldAfmResource != null) {
                            String airdContent = "";
                            try {
                                airdContent = FileHelper.readFile((String)RenameResourceAction.this.newPath.toString());
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                            if (airdContent.contains("<semanticResources>" + oldAfmPath.lastSegment())) {
                                IPath newAfmPath = RenameResourceAction.this.changeExtension(RenameResourceAction.this.newPath, "afm");
                                RenameResourceAction.this.renameResource(oldAfmResource, newAfmPath, monitor, errorStatus);
                            }
                        }
                    }
                }
            }
        };
    }

    private IPath changeExtension(IPath inPath, String newExtension) {
        IPath newPath = inPath;
        String oldExtension = inPath.getFileExtension();
        if (oldExtension != null && !oldExtension.isEmpty()) {
            newPath = inPath.removeLastSegments(1).append(inPath.lastSegment().replace(".aird", ".afm"));
        }
        return newPath;
    }

    private void renameResource(IResource oldResource, IPath newResourcePath, IProgressMonitor monitor, IStatus[] errorStatus) {
        boolean go = true;
        IWorkspaceRoot workspaceRoot = oldResource.getWorkspace().getRoot();
        IResource newResource = workspaceRoot.findMember(newResourcePath);
        if (newResource != null) {
            go = this.checkOverwrite(this._shell, newResource);
        }
        if (go) {
            String resourceNameBeforeRenaming = oldResource.getName();
            MoveResourcesOperation op = new MoveResourcesOperation(oldResource, newResourcePath, IDEWorkbenchMessages.RenameResourceAction_operationTitle);
            op.setModelProviderIds(this.getModelProviderIds());
            try {
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this._shell));
                boolean updateCapellaProjectName = "melodymodeller".equals(oldResource.getFileExtension());
                this.updateReferencesToFile(oldResource.getProject(), resourceNameBeforeRenaming, newResourcePath.lastSegment(), updateCapellaProjectName);
            }
            catch (UnsupportedEncodingException e) {
                errorStatus[0] = new Status(4, "org.eclipse.ui", "Rename action failed to perform because UTF-8 encoding is not supported", (Throwable)e);
            }
            catch (ExecutionException e) {
                errorStatus[0] = e.getCause() instanceof CoreException ? ((CoreException)e.getCause()).getStatus() : new Status(4, "org.eclipse.ui", this.getProblemsMessage(), (Throwable)e);
            }
        }
    }

    Composite createParent() {
        Tree tree = this.getTree();
        Composite result = new Composite((Composite)tree, 0);
        TreeItem[] selectedItems = tree.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private void createTextEditor(final IResource resource) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        final int inset = RenameResourceAction.getCellEditorInset((Control)this.textEditorParent);
        if (inset > 0) {
            this.textEditorParent.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Point textSize = RenameResourceAction.this.textEditor.getSize();
                    Point parentSize = RenameResourceAction.this.textEditorParent.getSize();
                    e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
                }
            });
        }
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.navigatorTree.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameResourceAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameResourceAction.this.textEditorParent.getSize();
                RenameResourceAction.this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
                RenameResourceAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameResourceAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameResourceAction.this.saveChangesAndDispose(resource);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameResourceAction.this.saveChangesAndDispose(resource);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    void displayError2(String message) {
        MessageDialog.openError((Shell)this._shell, (String)this.getProblemsTitle(), (String)(message == null ? IDEWorkbenchMessages.WorkbenchAction_internalError : message));
    }

    private void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    protected List getActionResources() {
        if (this.inlinedResource == null) {
            return super.getActionResources();
        }
        ArrayList<IResource> actionResources = new ArrayList<IResource>();
        actionResources.add(this.inlinedResource);
        return actionResources;
    }

    private IResource getCurrentResource() {
        List resources = this.getSelectedResources();
        if (resources.size() == 1) {
            return (IResource)resources.get(0);
        }
        return null;
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_progress;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.RenameResourceAction_problemTitle;
    }

    private Tree getTree() {
        return this.navigatorTree;
    }

    protected void invokeOperation(IResource resource, IProgressMonitor monitor) {
    }

    protected String queryNewResourceName(final IResource resource) {
        final IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        final IPath prefix = resource.getFullPath().removeLastSegments(1);
        IInputValidator validator = new IInputValidator(){

            public String isValid(String string) {
                if (resource.getName().equals(string)) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameMustBeDifferent;
                }
                IStatus status = workspace.validateName(string, resource.getType());
                if (!status.isOK()) {
                    return status.getMessage();
                }
                if (workspace.getRoot().exists(prefix.append(string))) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameExists;
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this._shell, IDEWorkbenchMessages.RenameResourceAction_inputDialogTitle, IDEWorkbenchMessages.RenameResourceAction_inputDialogMessage, resource.getName(), validator);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private void queryNewResourceNameInline(IResource resource) {
        if (this.textEditorParent == null) {
            this.createTextEditor(resource);
        }
        this.textEditor.setText(resource.getName());
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = RenameResourceAction.getCellEditorInset((Control)this.textEditorParent);
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    private String replaceSpecialCharacter(String source_p, char specialCharacter_p, String replacingSpecialCharacter_p) {
        String result = source_p;
        if (result.contains("" + specialCharacter_p)) {
            result = result.replace("" + specialCharacter_p, replacingSpecialCharacter_p);
        }
        return result;
    }

    public void run() {
        if (this.navigatorTree == null) {
            IResource currentResource = this.getCurrentResource();
            if (currentResource == null || !currentResource.exists()) {
                return;
            }
            if (!this.checkReadOnlyAndNull(currentResource)) {
                return;
            }
            String newName = this.queryNewResourceName(currentResource);
            if (newName == null || newName.equals("")) {
                return;
            }
            this.newPath = currentResource.getFullPath().removeLastSegments(1).append(newName);
            super.run();
        } else {
            this.runWithInlineEditor();
        }
    }

    private void runWithInlineEditor() {
        IResource currentResource = this.getCurrentResource();
        if (!this.checkReadOnlyAndNull(currentResource)) {
            return;
        }
        this.queryNewResourceNameInline(currentResource);
    }

    protected void runWithNewPath(IPath path, IResource resource) {
        this.newPath = path;
        super.run();
    }

    protected void saveChangesAndDispose(IResource resource) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        this.inlinedResource = resource;
        final String newName = this.textEditor.getText();
        Runnable query = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!newName.equals(RenameResourceAction.this.inlinedResource.getName())) {
                        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
                        IStatus status = workspace.validateName(newName, RenameResourceAction.this.inlinedResource.getType());
                        if (!status.isOK()) {
                            RenameResourceAction.this.displayError2(status.getMessage());
                        } else {
                            IPath newPath_l = RenameResourceAction.this.inlinedResource.getFullPath().removeLastSegments(1).append(newName);
                            RenameResourceAction.this.runWithNewPath(newPath_l, RenameResourceAction.this.inlinedResource);
                        }
                    }
                    RenameResourceAction.this.inlinedResource = null;
                    RenameResourceAction.this.disposeTextWidget();
                    if (RenameResourceAction.this.navigatorTree != null && !RenameResourceAction.this.navigatorTree.isDisposed()) {
                        RenameResourceAction.this.navigatorTree.setFocus();
                    }
                }
                finally {
                    RenameResourceAction.this.saving = false;
                }
            }
        };
        this.getTree().getShell().getDisplay().asyncExec(query);
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    public void setTextActionHandler(TextActionHandler actionHandler) {
        this.textActionHandler = actionHandler;
    }

    private String updateCapellaProjectName(String initialContent_p, String oldName_p, String newName_p) {
        String result = null;
        int indexOfCapellaProjectName = initialContent_p.indexOf(CAPELLA_PROJECT_NAME_ATT);
        if (indexOfCapellaProjectName != -1) {
            String oldName = this.replaceSpecialCharacter(oldName_p, '&', AND_HTML_REPRESENTATION);
            String newName = this.replaceSpecialCharacter(newName_p, '&', AND_HTML_REPRESENTATION);
            oldName = oldName.substring(0, oldName.indexOf(46));
            newName = newName.substring(0, newName.indexOf(46));
            oldName = this.normalizeForName(oldName);
            newName = this.normalizeForName(newName);
            StringBuilder content = new StringBuilder(initialContent_p);
            int start = indexOfCapellaProjectName + CAPELLA_PROJECT_NAME_ATT.length();
            int end = initialContent_p.indexOf("\"", start);
            content.replace(start, end, newName);
            result = content.toString();
        }
        if (result == null) {
            return initialContent_p;
        }
        return result;
    }

    private void updateReferencesFor(IResource[] members_p, String newName_p, String oldName_p, boolean updateCapellaProjectName_p) throws CoreException, UnsupportedEncodingException {
        IResource[] iResourceArray = members_p;
        int n = members_p.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            switch (resource.getType()) {
                case 1: {
                    String fileExtension = resource.getFileExtension();
                    if (!CapellaResourceHelper.isCapellaResource((IResource)resource) && !"aird".equals(fileExtension) && !"airdfragment".equals(fileExtension) && !"afm".equals(fileExtension)) break;
                    IFile file = (IFile)resource;
                    String filePath = file.getFullPath().toString();
                    String initialContent = null;
                    String newContent = null;
                    if (resource.getName().equals(newName_p)) {
                        if (updateCapellaProjectName_p) {
                            initialContent = FileHelper.readFile((String)filePath);
                            newContent = this.updateCapellaProjectName(initialContent, oldName_p, newName_p);
                        }
                    } else {
                        initialContent = FileHelper.readFile((String)filePath);
                        newContent = this.replace(initialContent, oldName_p, newName_p);
                    }
                    if (initialContent == null || initialContent.equals(newContent)) break;
                    FileHelper.writeFile((String)filePath, (boolean)false, (String)newContent);
                    file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                case 2: {
                    this.updateReferencesFor(((IFolder)resource).members(), newName_p, oldName_p, false);
                }
            }
            ++n2;
        }
    }

    private String replace(String initialContent_p, String oldName_p, String newName_p) {
        String newContent = null;
        String oldName = this.normalizeForContent(oldName_p);
        String newName = this.normalizeForContent(newName_p);
        newContent = initialContent_p.replaceAll("\\b" + Pattern.quote(oldName) + "\\b", newName);
        if (oldName.contains(Character.toString('&'))) {
            oldName = this.replaceSpecialCharacter(oldName, '&', AND_HTML_REPRESENTATION);
            newContent = newContent.replaceAll("\\b" + Pattern.quote(oldName) + "\\b", newName);
        }
        return newContent;
    }

    private String normalizeForContent(String content) {
        String _return = this.normalizeForName(content);
        return URI.encodeSegment((String)_return, (boolean)true);
    }

    private String normalizeForName(String content) {
        String _return = null;
        try {
            _return = new String(content.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return _return;
    }

    protected void updateReferencesToFile(IProject project_p, String oldName_p, String newName_p, boolean updateCapellaProjectName_p) throws UnsupportedEncodingException {
        try {
            this.updateReferencesFor(project_p.members(), newName_p, oldName_p, updateCapellaProjectName_p);
        }
        catch (CoreException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("RenameResourceAction.updateReferencesToFile(..) _ ");
            loggerMessage.append(exception_p.getMessage());
            __logger.warn((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"), (Throwable)exception_p);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.disposeTextWidget();
        if (selection.size() > 1) {
            return false;
        }
        if (selection.getFirstElement() instanceof IFolder) {
            return false;
        }
        if (!super.updateSelection(selection)) {
            return false;
        }
        IResource currentResource = this.getCurrentResource();
        return currentResource != null && currentResource.exists();
    }

    private static int getCellEditorInset(Control c) {
        return 1;
    }
}

