/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.RenameResourceAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.internal.ResourceSelectionUtil;

public class RefactorActionProvider
extends CommonActionProvider {
    private UndoRedoActionGroup _undoRedoGroup;
    private RefactorActionGroup _refactorGroup;
    private ICommonActionExtensionSite _site;

    public void dispose() {
        this._undoRedoGroup.dispose();
        this._refactorGroup.dispose();
    }

    public void fillActionBars(IActionBars actionBars) {
        this._undoRedoGroup.fillActionBars(actionBars);
        this._refactorGroup.fillActionBars(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        this._undoRedoGroup.fillContextMenu(menu);
        this._refactorGroup.fillContextMenu(menu);
    }

    public void init(ICommonActionExtensionSite anActionSite) {
        this._site = anActionSite;
        this._refactorGroup = new RefactorActionGroup(this._site.getViewSite().getShell(), (Tree)this._site.getStructuredViewer().getControl());
        IUndoContext workspaceContext = (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class);
        this._undoRedoGroup = new UndoRedoActionGroup(((ICommonViewerWorkbenchSite)anActionSite.getViewSite()).getSite(), workspaceContext, true);
    }

    public void setContext(ActionContext context) {
        this._undoRedoGroup.setContext(context);
        this._refactorGroup.setContext(context);
    }

    public void updateActionBars() {
        this._undoRedoGroup.updateActionBars();
        this._refactorGroup.updateActionBars();
    }

    class RefactorActionGroup
    extends ActionGroup {
        private RenameResourceAction _renameAction;
        private MoveResourceAction _moveAction;
        private Shell _shell;
        private Tree _tree;

        public RefactorActionGroup(Shell aShell, Tree aTree) {
            this._shell = aShell;
            this._tree = aTree;
            this.makeActions();
        }

        public void fillActionBars(IActionBars actionBars) {
            this.updateActionBars();
            actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this._moveAction);
            actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this._renameAction);
        }

        public void fillContextMenu(IMenuManager menu) {
            boolean anyResourceSelected;
            IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
            boolean bl = anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(selection, 7);
            if (anyResourceSelected) {
                this._moveAction.selectionChanged(selection);
                menu.appendToGroup("group.reorganize", (IAction)this._moveAction);
                this._renameAction.selectionChanged(selection);
                menu.insertAfter(this._moveAction.getId(), (IAction)this._renameAction);
            }
        }

        public void handleKeyPressed(KeyEvent event) {
            if (event.keyCode == 0x100000B && event.stateMask == 0) {
                if (this._renameAction.isEnabled()) {
                    this._renameAction.run();
                }
                event.doit = false;
            }
        }

        protected void makeActions() {
            this._moveAction = new MoveResourceAction(this._shell);
            this._moveAction.setActionDefinitionId("org.eclipse.ui.edit.move");
            this._renameAction = new RenameResourceAction(this._shell, this._tree);
            this._renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        }

        public void updateActionBars() {
            IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
            this._moveAction.selectionChanged(selection);
            this._renameAction.selectionChanged(selection);
        }
    }
}

