/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.validation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.polarsys.capella.core.model.handler.ModelHandlerPlugin;
import org.polarsys.capella.core.model.handler.validation.AbstractDiagnosticianProvider;
import org.polarsys.capella.core.model.handler.validation.CapellaDiagnostician;

public class PluggableDiagnosticianProvider
extends AbstractDiagnosticianProvider {
    public static final String DIAGNOSTICIAN_PROVIDER_EXTENSION = String.valueOf(ModelHandlerPlugin.PLUGIN_ID) + ".diagnosticianProviders";

    @Override
    public Diagnostician getDiagnostician(AdapterFactory adapterFactory_p, IProgressMonitor progressMonitor_p) {
        CapellaDiagnostician result = null;
        IConfigurationElement[] elems = Platform.getExtensionRegistry().getConfigurationElementsFor(DIAGNOSTICIAN_PROVIDER_EXTENSION);
        if (elems != null && elems.length == 1) {
            try {
                AbstractDiagnosticianProvider provider = (AbstractDiagnosticianProvider)elems[0].createExecutableExtension("class");
                result = provider.getDiagnostician(adapterFactory_p, progressMonitor_p);
            }
            catch (CoreException e1) {
                ModelHandlerPlugin.getDefault().getLog().log((IStatus)new Status(4, ModelHandlerPlugin.PLUGIN_ID, e1.getMessage(), (Throwable)e1));
            }
        }
        if (result == null) {
            result = new CapellaDiagnostician(adapterFactory_p, progressMonitor_p);
        }
        return result;
    }
}

