/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManagerForSemanticElementsFactory;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManagerForSemanticElementsFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.AbstractCopyPasteFormatAction;
import org.eclipse.sirius.diagram.ui.tools.internal.format.data.extension.FormatDataManagerRegistry;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.data.extension.LayoutDataManagerRegistry;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class PasteFormatAction
extends AbstractCopyPasteFormatAction {
    public PasteFormatAction(IWorkbenchPage workbenchPage, IWorkbenchPart actionWorkbenchPart) {
        super(workbenchPage, actionWorkbenchPart);
        this.setText(Messages.PasteFormatAction_text);
        this.setAccelerator(458838);
        this.setId("pasteFormatAction");
        this.setToolTipText(Messages.PasteFormatAction_toolTipText);
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteFormat.gif"));
        this.setDisabledImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteFormatDisabled.gif"));
        this.setHoverImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteFormat.gif"));
    }

    public PasteFormatAction(IWorkbenchPage workbenchPage) {
        this(workbenchPage, null);
    }

    protected String getCommandLabel() {
        return Messages.PasteFormatAction_commandLabel;
    }

    protected Command getCommand() {
        UnexecutableCommand pasteFormatCommand = UnexecutableCommand.INSTANCE;
        if (SiriusFormatDataManagerForSemanticElementsFactory.getInstance().getSiriusFormatDataManager().containsData() || SiriusLayoutDataManagerForSemanticElementsFactory.getInstance().getSiriusLayoutDataManager().containsData()) {
            Option<DDiagram> diagram;
            CompoundCommand doPasteFormatsCmd = new CompoundCommand(Messages.PasteFormatAction_restoreFormatCommandLabel);
            Iterator iter = this.getSelectedObjects().iterator();
            DiagramEditPart diagramEditPart = this.getDiagramEditPart();
            if (diagramEditPart instanceof IDDiagramEditPart && (diagram = ((IDDiagramEditPart)diagramEditPart).resolveDDiagram()).some() && PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)diagram.get()).canEditInstance((EObject)diagram.get())) {
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (!(next instanceof IGraphicalEditPart)) continue;
                    IGraphicalEditPart torestore = (IGraphicalEditPart)next;
                    doPasteFormatsCmd.add((Command)new ICommandProxy((ICommand)new PasteFormatDataCommand(torestore.getEditingDomain(), (DDiagram)diagram.get(), torestore)));
                }
            }
            pasteFormatCommand = doPasteFormatsCmd.unwrap();
        }
        return pasteFormatCommand;
    }

    private static final class PasteFormatDataCommand
    extends AbstractTransactionalCommand {
        private IGraphicalEditPart editPartToRestore;
        private DDiagram dDiagram;

        PasteFormatDataCommand(TransactionalEditingDomain domain, DDiagram dDiagram, IGraphicalEditPart editPartToRestore) {
            super(domain, Messages.PasteFormatDataCommand_label, null);
            this.dDiagram = dDiagram;
            this.editPartToRestore = editPartToRestore;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            List<SiriusFormatDataManager> formatDataManagers = FormatDataManagerRegistry.getSiriusFormatDataManagers(this.dDiagram);
            if (!formatDataManagers.isEmpty()) {
                List<SiriusLayoutDataManager> layoutDataManagers;
                boolean deprecatedLayoutManagerUsed = false;
                if (formatDataManagers.size() == 1 && SiriusFormatDataManagerForSemanticElementsFactory.getInstance().getSiriusFormatDataManager().equals(formatDataManagers.get(0)) && (layoutDataManagers = LayoutDataManagerRegistry.getSiriusLayoutDataManagers(this.dDiagram)).size() > 1) {
                    deprecatedLayoutManagerUsed = true;
                    layoutDataManagers.get(0).applyFormat(this.editPartToRestore);
                }
                if (!deprecatedLayoutManagerUsed) {
                    formatDataManagers.get(0).applyFormat(this.editPartToRestore);
                }
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

