/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ExtensionHelper {
    public static Collection<String> collectDomainFromExtensions(IContext context, String expectedPurpose, String expectedMapping) {
        return ExtensionHelper.collectStringFromExtensions(context, "org.polarsys.capella.core.transition.handlers", "domain", expectedPurpose, expectedMapping);
    }

    protected static Collection<String> collectStringFromExtensions(IContext context, String extension_id, String string, String expectedPurpose, String expectedMapping) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(extension_id);
        LinkedList<String> result = new LinkedList<String>();
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ExtensionHelper.isValidExtension(element, expectedPurpose, expectedMapping)) {
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    if (string.equals(child.getName())) {
                        result.add(child.getAttribute("id"));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    protected static boolean isValidExtension(IConfigurationElement element, String expectedPurpose, String expectedMapping) {
        if (!"handlers".equals(element.getName())) {
            return false;
        }
        String purpose = element.getAttribute("purpose");
        String mapping = element.getAttribute("mapping");
        return !(!purpose.equals(expectedPurpose) && !"all".equals(purpose) && !"all".equals(expectedPurpose) || !mapping.equals(expectedMapping) && !"all".equals(mapping) && !"all".equals(expectedMapping));
    }

    public static Collection<IHandler> collectFromExtensions(IContext context, String extension_id, String childName, String expectedPurpose, String expectedMapping) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(extension_id);
        LinkedList<IHandler> result = new LinkedList<IHandler>();
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ExtensionHelper.isValidExtension(element, expectedPurpose, expectedMapping)) {
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    if (childName.equals(child.getName())) {
                        try {
                            Object extension = child.createExecutableExtension("class");
                            if (extension != null && extension instanceof IHandler) {
                                result.add((IHandler)extension);
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    public static Collection<IHandler> collectActivityExtendersFromExtensions(IContext context, String extension_id, String activityIdentifer, String expectedPurpose, String expectedMapping) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(extension_id);
        LinkedList<IHandler> result = new LinkedList<IHandler>();
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ExtensionHelper.isValidExtension(element, expectedPurpose, expectedMapping)) {
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String identifier;
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    if ("activityExtender".equals(child.getName()) && (activityIdentifer.equals(identifier = child.getAttribute("activityIdentifier")) || "all".equals(identifier))) {
                        try {
                            Object extension = child.createExecutableExtension("class");
                            if (extension != null && extension instanceof IHandler) {
                                result.add((IHandler)extension);
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }
}

