/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.transposer.current;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.polarsys.capella.core.transition.common.transposer.current.IRuleMappingExtensionConstants;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IDomainHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.CommonFactory;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.Mapping;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingElement;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingPackage;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingPossibility;
import org.polarsys.kitalpha.transposer.rules.handler.rules.contribution.ContributedPurpose;
import org.polarsys.kitalpha.transposer.rules.handler.rules.contribution.ContributionFactory;

public class RuleMappingExtensionService
implements IRuleMappingExtensionConstants {
    protected static RuleMappingExtensionService __instance = new RuleMappingExtensionService();
    protected Map _contributedPurposes = new HashMap();
    protected Map _mappingsHashMap;
    protected Map _classNameToIRule = new HashMap();
    protected boolean _contributedPurposesLoaded = false;

    protected RuleMappingExtensionService() {
        this._mappingsHashMap = new HashMap();
    }

    public static RuleMappingExtensionService getInstance() {
        return __instance;
    }

    public Collection getContributedPurposes() {
        if (!this._contributedPurposesLoaded) {
            this.loadContributedPurposes();
        }
        return this._contributedPurposes.values();
    }

    public void loadContributedPurposes() {
        this._contributedPurposes.clear();
        this._mappingsHashMap.clear();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            Mapping currentMapping;
            IConfigurationElement mappingConfigurationElement;
            String currentMappingID;
            IExtension extension;
            IExtension[] extensions;
            IExtension[] aiextension = extensions = Platform.getExtensionRegistry().getExtensionPoint("org.polarsys.kitalpha.transposer.rules.handler.mapping").getExtensions();
            int l = extensions.length;
            int i = 0;
            while (i < l) {
                extension = aiextension[i];
                currentMappingID = extension.getUniqueIdentifier();
                IConfigurationElement[] aiconfigurationelement = extension.getConfigurationElements();
                int k1 = aiconfigurationelement.length;
                int i1 = 0;
                while (i1 < k1) {
                    mappingConfigurationElement = aiconfigurationelement[i1];
                    if (mappingConfigurationElement.getName().equals("mapping")) {
                        currentMapping = this.createMapping(mappingConfigurationElement);
                        String purpose = mappingConfigurationElement.getAttribute("mappingPurpose");
                        ContributedPurpose currentPurpose = this.getCurrentPurpose(purpose);
                        currentPurpose.getMappings().add((Object)currentMapping);
                        currentMapping.setId(currentMappingID);
                        this._mappingsHashMap.put(currentMappingID, currentMapping);
                    }
                    ++i1;
                }
                ++i;
            }
            aiextension = extensions;
            l = extensions.length;
            int j = 0;
            while (j < l) {
                extension = aiextension[j];
                currentMappingID = extension.getUniqueIdentifier();
                Mapping currentMapping2 = (Mapping)this._mappingsHashMap.get(currentMappingID);
                String extendedMappingID = this.getExtendedMappingID(extension);
                if (extendedMappingID != null) {
                    Mapping extendedMapping = (Mapping)this._mappingsHashMap.get(extendedMappingID);
                    currentMapping2.setExtendedMapping(extendedMapping);
                }
                ++j;
            }
            aiextension = extensions;
            l = extensions.length;
            int k = 0;
            while (k < l) {
                extension = aiextension[k];
                currentMappingID = extension.getUniqueIdentifier();
                IConfigurationElement[] aiconfigurationelement1 = extension.getConfigurationElements();
                int l1 = aiconfigurationelement1.length;
                int j1 = 0;
                while (j1 < l1) {
                    mappingConfigurationElement = aiconfigurationelement1[j1];
                    if (mappingConfigurationElement.getName().equals("mapping") && this._mappingsHashMap.containsKey(currentMappingID)) {
                        currentMapping = (Mapping)this._mappingsHashMap.get(currentMappingID);
                        try {
                            this.loadMapping(currentMapping, mappingConfigurationElement);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++j1;
                }
                ++k;
            }
        }
        ArrayList<Mapping> roots = new ArrayList<Mapping>();
        for (ContributedPurpose purpose : this._contributedPurposes.values()) {
            Mapping mostGenericMappingInPurpose = purpose.getMostGenericMapping();
            if (mostGenericMappingInPurpose.getExtendedMapping() != null) continue;
            roots.add(mostGenericMappingInPurpose);
        }
        for (Mapping rootMapping : roots) {
            this.handleMappingElementHierarchy(rootMapping, new HashMap());
        }
        this._contributedPurposesLoaded = true;
    }

    protected void handleMappingElementHierarchy(Mapping mapping, HashMap hashMap) {
        for (MappingElement element : mapping.getAllOwnedMappingElements()) {
            if (hashMap.containsKey(element.getDomainMetaClass())) {
                element.setExtendedMappingElement((MappingElement)hashMap.get(element.getDomainMetaClass()));
            }
            hashMap.put(element.getDomainMetaClass(), element);
        }
        if (mapping.getExtenders() != null && mapping.getExtenders().size() > 0) {
            for (Mapping extender : mapping.getExtenders()) {
                this.handleMappingElementHierarchy(extender, new HashMap(hashMap));
            }
        }
    }

    protected ContributedPurpose getCurrentPurpose(String purpose) {
        ContributedPurpose currentPurpose;
        if (this._contributedPurposes.containsKey(purpose)) {
            currentPurpose = (ContributedPurpose)this._contributedPurposes.get(purpose);
        } else {
            currentPurpose = ContributionFactory.eINSTANCE.createContributedPurpose();
            currentPurpose.setName(purpose);
            this._contributedPurposes.put(purpose, currentPurpose);
        }
        return currentPurpose;
    }

    protected String getExtendedMappingID(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        IConfigurationElement mappingConfigurationElement = elements[0];
        if (!mappingConfigurationElement.getName().equals("mapping")) {
            return null;
        }
        return mappingConfigurationElement.getAttribute("extendedMappingExtensionID");
    }

    protected Mapping createMapping(IConfigurationElement mappingConfigurationElement) {
        Mapping currentMapping = CommonFactory.eINSTANCE.createMapping();
        currentMapping.setName(mappingConfigurationElement.getAttribute("mappingName"));
        currentMapping.setDescription(mappingConfigurationElement.getAttribute("description"));
        if (mappingConfigurationElement.getAttribute("domainHelper") != null) {
            try {
                currentMapping.setOwnedDomainHelper((IDomainHelper)mappingConfigurationElement.createExecutableExtension("domainHelper"));
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }
        if (mappingConfigurationElement.getAttribute("context") != null) {
            try {
                currentMapping.setOwnedContext((IContext)mappingConfigurationElement.createExecutableExtension("context"));
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }
        return currentMapping;
    }

    protected void loadMapping(Mapping currentMapping, IConfigurationElement mappingConfigurationElement) {
        IConfigurationElement[] mappingChildren;
        IConfigurationElement[] aiconfigurationelement = mappingChildren = mappingConfigurationElement.getChildren();
        int j = mappingChildren.length;
        int i = 0;
        while (i < j) {
            IConfigurationElement configurationElement = aiconfigurationelement[i];
            if (configurationElement.getName().equals("mappingElement")) {
                currentMapping.getOwnedMappingElements().add((Object)this.handleMappingElement(configurationElement, currentMapping));
            }
            if (configurationElement.getName().equals("mappingPackage")) {
                currentMapping.getOwnedPackages().add((Object)this.handleMappingPackage(configurationElement, currentMapping));
            }
            ++i;
        }
    }

    protected MappingPackage handleMappingPackage(IConfigurationElement packageConfigurationElement, Mapping currentMapping) {
        IConfigurationElement[] mappingChildren;
        MappingPackage currentPackage = CommonFactory.eINSTANCE.createMappingPackage();
        currentPackage.setName(packageConfigurationElement.getAttribute("name"));
        IConfigurationElement[] aiconfigurationelement = mappingChildren = packageConfigurationElement.getChildren();
        int j = mappingChildren.length;
        int i = 0;
        while (i < j) {
            IConfigurationElement configurationElement = aiconfigurationelement[i];
            if (configurationElement.getName().equals("mappingElement")) {
                currentPackage.getOwnedMappingElements().add((Object)this.handleMappingElement(configurationElement, currentMapping));
            }
            if (configurationElement.getName().equals("mappingPackage")) {
                currentPackage.getOwnedPackages().add((Object)this.handleMappingPackage(configurationElement, currentMapping));
            }
            ++i;
        }
        return currentPackage;
    }

    protected MappingElement handleMappingElement(IConfigurationElement configurationElement, Mapping currentMapping) {
        IConfigurationElement[] possibilities;
        IConfigurationElement[] defaultPossibilities;
        MappingElement currentElement = CommonFactory.eINSTANCE.createMappingElement();
        String name = configurationElement.getAttribute("name");
        currentElement.setName(name);
        String domainMetaclassName = configurationElement.getAttribute("domainMetaClass");
        currentElement.setDomainMetaClass(currentMapping.getDomainHelper().getDomainMetaclass(domainMetaclassName));
        String reusedSuperPossibilities = configurationElement.getAttribute("reuseExtendedElementPossibilities");
        currentElement.setReuseSuperPossibilities(Boolean.parseBoolean(reusedSuperPossibilities));
        String reusedSuperDefaultPossibility = configurationElement.getAttribute("reuseExtendedElementDefaultPossibility");
        currentElement.setReuseSuperDefaultPossibility(Boolean.parseBoolean(reusedSuperDefaultPossibility));
        IConfigurationElement[] aiconfigurationelement = defaultPossibilities = configurationElement.getChildren("defaultMappingPossibility");
        int j = defaultPossibilities.length;
        int i = 0;
        while (i < j) {
            IConfigurationElement defaultPossibility = aiconfigurationelement[i];
            currentElement.setOwnedDefaultPossibility(this.handlePossibility(defaultPossibility));
            ++i;
        }
        IConfigurationElement[] aiconfigurationelement1 = possibilities = configurationElement.getChildren("mappingPossibility");
        int l = possibilities.length;
        int k = 0;
        while (k < l) {
            IConfigurationElement possibility = aiconfigurationelement1[k];
            currentElement.getOwnedPossibilities().add((Object)this.handlePossibility(possibility));
            ++k;
        }
        return currentElement;
    }

    protected MappingPossibility handlePossibility(IConfigurationElement possibilityConfigurationElement) {
        String incompleteRuleClassName;
        MappingPossibility currentPossibility = CommonFactory.eINSTANCE.createMappingPossibility();
        currentPossibility.setName(possibilityConfigurationElement.getAttribute("name"));
        String enabled = possibilityConfigurationElement.getAttribute("enabled");
        if (!Boolean.parseBoolean(enabled)) {
            return currentPossibility;
        }
        String completeRuleClassName = possibilityConfigurationElement.getAttribute("completeRule");
        if (completeRuleClassName != null) {
            if (this._classNameToIRule.containsKey(completeRuleClassName)) {
                currentPossibility.setCompleteRule((IRule)this._classNameToIRule.get(completeRuleClassName));
            } else {
                try {
                    currentPossibility.setCompleteRule((IRule)possibilityConfigurationElement.createExecutableExtension("completeRule"));
                }
                catch (CoreException exception) {
                    exception.printStackTrace();
                }
            }
        }
        if ((incompleteRuleClassName = possibilityConfigurationElement.getAttribute("incompleteRule")) != null) {
            if (this._classNameToIRule.containsKey(incompleteRuleClassName)) {
                currentPossibility.setIncompleteRule((IRule)this._classNameToIRule.get(incompleteRuleClassName));
            } else {
                try {
                    currentPossibility.setIncompleteRule((IRule)possibilityConfigurationElement.createExecutableExtension("incompleteRule"));
                }
                catch (CoreException exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (possibilityConfigurationElement.getAttribute("context") != null) {
            try {
                currentPossibility.setContext((IContext)possibilityConfigurationElement.createExecutableExtension("context"));
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }
        return currentPossibility;
    }

    public void reset() {
        this._contributedPurposesLoaded = false;
        this._classNameToIRule.clear();
        this._contributedPurposes.clear();
        this._mappingsHashMap.clear();
    }

    public void dispose() {
        this._contributedPurposesLoaded = false;
        this._contributedPurposes.clear();
    }
}

