/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.refresh.command;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.command.RefreshDiagramOnOpeningCommand;
import org.eclipse.sirius.diagram.ui.internal.refresh.SynchronizeGMFModelCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.contrib.refresh.Messages;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;

public class RefreshRepresentation
extends ModelCommand {
    Logger LOGGER = Logger.getLogger(RefreshRepresentation.class);

    public void exec(ModelScrutinyRegistry analysis, Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        if (resource.getURI().lastSegment() == null || !resource.getURI().lastSegment().endsWith("aird")) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        Session session = SessionManager.INSTANCE.getExistingSession(resource.getURI());
        if (session == null) {
            session = SessionManager.INSTANCE.getSession(resource.getURI(), (IProgressMonitor)subMonitor);
        }
        if (!session.isOpen()) {
            session.open((IProgressMonitor)subMonitor);
        }
        subMonitor.beginTask(Messages.REFRESH_REMPRESENTATIONS, -1);
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        CompoundCommand compoundCommand = new CompoundCommand("Refresh Diagrams");
        this.refreshGMFModelDiagrams(allRepresentations, domain, compoundCommand);
        RefreshRepresentationsCommand refreshDRepresentations = new RefreshRepresentationsCommand(domain, (IProgressMonitor)subMonitor, allRepresentations);
        compoundCommand.append((Command)refreshDRepresentations);
        if (compoundCommand.canExecute()) {
            domain.getCommandStack().execute((Command)compoundCommand);
        }
        subMonitor.subTask(Messages.SAVE_SIRIUS_SESSION);
        session.save((IProgressMonitor)subMonitor);
        subMonitor.subTask(Messages.CLOSING_SIRIUS_SESSION);
        session.close((IProgressMonitor)subMonitor);
        subMonitor.done();
    }

    private void refreshGMFModelDiagrams(Collection<DRepresentation> allRepresentations, TransactionalEditingDomain ed, CompoundCommand compoundCommand) {
        for (DRepresentation representation : allRepresentations) {
            if (!(representation instanceof DSemanticDiagram)) continue;
            DSemanticDiagram diagram = (DSemanticDiagram)representation;
            Diagram gmfDiagram = SiriusGMFHelper.getGmfDiagram((DDiagram)diagram);
            RefreshDiagramOnOpeningCommand refreshOnOpening = new RefreshDiagramOnOpeningCommand(ed, diagram);
            compoundCommand.append((Command)refreshOnOpening);
            compoundCommand.setLabel(refreshOnOpening.getLabel());
            CanonicalSynchronizer cs = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(gmfDiagram);
            SynchronizeGMFModelCommand refreshDSemanticDiagram = new SynchronizeGMFModelCommand(ed, cs);
            compoundCommand.append((Command)refreshDSemanticDiagram);
        }
    }
}

