/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MetricTree<T> {
    private MetricTree<T> parent = null;
    private List<MetricTree<T>> children = null;
    private T nodeId;
    private Integer data;

    public T getId() {
        return this.nodeId;
    }

    public Integer getData() {
        return this.data;
    }

    public void setData(Integer value_p) {
        this.data = value_p;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public MetricTree<T> getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public List<MetricTree<T>> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public void addChild(MetricTree<T> child_p) {
        this.addChildren(Collections.singletonList(child_p));
    }

    public void addChildren(List<MetricTree<T>> children_p) {
        if (!this.hasChildren()) {
            this.children = new ArrayList<MetricTree<T>>();
        }
        this.children.addAll(children_p);
    }

    public MetricTree(T id, Integer data, MetricTree<T> parent) {
        this.parent = parent;
        this.nodeId = id;
        this.data = data;
    }

    public void clear() {
        this.parent = null;
        this.nodeId = null;
        this.data = null;
        if (this.getChildren() != null) {
            for (MetricTree<T> current : this.getChildren()) {
                current.clear();
            }
            this.children.clear();
        }
    }
}

