/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.scenario.ScenarioTransform;
import org.polarsys.capella.core.projection.scenario.es2es.handlers.ScenarioES2ESHandler;
import org.polarsys.capella.core.projection.scenario.handlers.IScenarioHandler;
import org.polarsys.capella.core.tiger.ITransfo;

public class ES2ESTransform
extends ScenarioTransform {
    private static final String CAPELLA_SCENARIO_RULES = "org.polarsys.capella.core.projection.scenario.es2es";

    @Override
    protected String getRules() {
        return CAPELLA_SCENARIO_RULES;
    }

    @Override
    protected IScenarioHandler createScenarioHandler(IContext context_p) {
        return new ScenarioES2ESHandler();
    }

    protected boolean retainContextElement(EObject contextElement, ITransfo transfo) {
        if (contextElement instanceof Scenario) {
            BlockArchitecture targetBlock = null;
            BlockArchitecture sourceBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement);
            for (AbstractTrace trace : sourceBlock.getIncomingTraces()) {
                TraceableElement targetElement = trace.getSourceElement();
                if (!(targetElement instanceof BlockArchitecture)) continue;
                targetBlock = (BlockArchitecture)targetElement;
            }
            if (targetBlock != null) {
                transfo.put((Object)"transfoSource", (Object)contextElement);
                transfo.put((Object)"transfoTarget", (Object)this.getTransitionedScenario((Scenario)contextElement, transfo));
                transfo.put((Object)"transfoTargetContainer", (Object)targetBlock);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isValidTransitionedScenario(Scenario contextElement_p, Scenario scenario_p) {
        BlockArchitecture sourceBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement_p);
        BlockArchitecture targetBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario_p);
        return scenario_p.getKind() == contextElement_p.getKind() && !sourceBlock.equals(targetBlock);
    }
}

