/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.XMLWriter;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesViewContentHandler;

public class RepositoryRoot
extends PlatformObject {
    public static final String[] DEFAULT_AUTO_REFRESH_FILES = new String[]{".project"};
    private static final String DEFINED_MODULE_PREFIX = "module:";
    ICVSRepositoryLocation root;
    String name;
    TagCacheEntry rootTagCacheEntry = new TagCacheEntry((IPath)Path.ROOT, null);
    Map autoRefreshFiles = new HashMap();
    Map modulesCache;
    Object modulesCacheLock = new Object();
    List dateTags = new ArrayList();

    public RepositoryRoot(ICVSRepositoryLocation root) {
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public ICVSRemoteFolder getRemoteFolder(String path, CVSTag tag, IProgressMonitor monitor) {
        if (RepositoryRoot.isDefinedModuleName(path)) {
            return this.getDefinedModule(RepositoryRoot.getDefinedModuleName(path), tag, monitor);
        }
        return this.root.getRemoteFolder(path, tag);
    }

    static boolean isDefinedModuleName(String path) {
        return path.startsWith(DEFINED_MODULE_PREFIX);
    }

    static String getDefinedModuleName(String path) {
        return path.substring(DEFINED_MODULE_PREFIX.length());
    }

    static String asDefinedModulePath(String path) {
        return DEFINED_MODULE_PREFIX + path;
    }

    private ICVSRemoteFolder getDefinedModule(String path, CVSTag tag, IProgressMonitor monitor) {
        Map cache = this.getDefinedModulesCache(tag, monitor);
        ICVSRemoteFolder folder = (ICVSRemoteFolder)cache.get(path);
        if (folder != null) {
            folder = (ICVSRemoteFolder)folder.forTag(tag);
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getDefinedModulesCache(CVSTag tag, IProgressMonitor monitor) {
        if (this.modulesCache == null) {
            try {
                ICVSRemoteResource[] folders = this.root.members(CVSTag.DEFAULT, true, monitor);
                Object object = this.modulesCacheLock;
                synchronized (object) {
                    this.modulesCache = new HashMap();
                    int i = 0;
                    while (i < folders.length) {
                        ICVSRemoteResource resource = folders[i];
                        this.modulesCache.put(resource.getName(), resource);
                        ++i;
                    }
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
                return new HashMap();
            }
        }
        return this.modulesCache;
    }

    public ICVSRemoteResource[] getDefinedModules(CVSTag tag, IProgressMonitor monitor) {
        Map cache = this.getDefinedModulesCache(tag, monitor);
        return cache.values().toArray(new ICVSRemoteResource[cache.size()]);
    }

    public static String getRemotePathFor(ICVSResource resource) throws CVSException {
        if (resource.isFolder()) {
            ICVSRemoteFolder remoteFolder;
            if (resource instanceof ICVSRemoteFolder && (remoteFolder = (ICVSRemoteFolder)resource).isDefinedModule()) {
                return RepositoryRoot.asDefinedModulePath(remoteFolder.getName());
            }
            FolderSyncInfo info = ((ICVSFolder)resource).getFolderSyncInfo();
            if (info == null) {
                throw new CVSException(NLS.bind((String)CVSUIMessages.RepositoryRoot_folderInfoMissing, (Object[])new String[]{resource.getName()}));
            }
            return info.getRepository();
        }
        FolderSyncInfo info = resource.getParent().getFolderSyncInfo();
        if (info == null) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.RepositoryRoot_folderInfoMissing, (Object[])new String[]{resource.getParent().getName()}));
        }
        String path = new Path(null, info.getRepository()).append(resource.getName()).toString();
        return path;
    }

    public ICVSRepositoryLocation getRoot() {
        return this.root;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addTags(String remotePath, CVSTag[] tags) {
        if (tags.length == 0) {
            return;
        }
        this.addDateTags(tags);
        this.addVersionAndBranchTags(remotePath, tags);
    }

    private void addDateTags(CVSTag[] tags) {
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getType() == 3) {
                this.dateTags.add(tags[i]);
            }
            ++i;
        }
    }

    private void addVersionAndBranchTags(String remotePath, CVSTag[] tags) {
        TagCacheEntry entry = this.getTagCacheEntryFor(remotePath, true);
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getType() != 3) {
                HashSet parentTags = new HashSet();
                this.addAllKnownTagsForParents(entry, parentTags);
                if (!parentTags.contains(tags[i])) {
                    entry.getTags().add(tags[i]);
                    this.removeTagFromChildrenCacheEntries(entry, tags[i]);
                }
            }
            ++i;
        }
    }

    public void addDateTag(CVSTag tag) {
        if (!this.dateTags.contains(tag)) {
            this.dateTags.add(tag);
        }
    }

    public void removeDateTag(CVSTag tag) {
        if (this.dateTags.contains(tag)) {
            this.dateTags.remove(tag);
        }
    }

    public CVSTag[] getDateTags() {
        return this.dateTags.toArray(new CVSTag[this.dateTags.size()]);
    }

    public void removeTags(String remotePath, CVSTag[] tags) {
        this.removeDateTags(tags);
        this.removeVersionAndBranchTags(remotePath, tags);
    }

    private void removeDateTags(CVSTag[] tags) {
        if (this.dateTags.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < tags.length) {
            this.dateTags.remove(tags[i]);
            ++i;
        }
    }

    private void removeVersionAndBranchTags(String remotePath, CVSTag[] tags) {
        TagCacheEntry entry = this.getTagCacheEntryFor(remotePath, false);
        if (entry != null) {
            this.removeTagsFromChildrenCacheEntries(entry, tags);
        }
        entry = this.getKnownParentTagCacheEntryFor(remotePath);
        int i = 0;
        while (i < tags.length) {
            if (entry.getTags().contains(tags[i])) {
                entry.getTags().remove(tags[i]);
            } else {
                TagCacheEntry currentEntry = entry;
                while (currentEntry.parent != null) {
                    if (currentEntry.parent.getTags().contains(tags[i])) {
                        currentEntry.parent.getTags().remove(tags[i]);
                        Iterator siblingIterator = currentEntry.parent.getChildrenIterator();
                        while (siblingIterator.hasNext()) {
                            TagCacheEntry sibling = (TagCacheEntry)siblingIterator.next();
                            if (sibling.equals(currentEntry)) continue;
                            sibling.getTags().add(tags[i]);
                        }
                        break;
                    }
                    currentEntry = currentEntry.parent;
                }
            }
            ++i;
        }
        if (entry.isEmpty()) {
            this.removeTagCacheEntry(entry);
        }
    }

    public String[] getAutoRefreshFiles(String remotePath) {
        Set files = (Set)this.autoRefreshFiles.get(remotePath);
        if (files == null || files.isEmpty()) {
            if (RepositoryRoot.isDefinedModuleName(remotePath)) {
                return new String[0];
            }
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < DEFAULT_AUTO_REFRESH_FILES.length) {
                String relativePath = DEFAULT_AUTO_REFRESH_FILES[i];
                result.add(new Path(null, remotePath).append(relativePath).toString());
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        return files.toArray(new String[files.size()]);
    }

    public void setAutoRefreshFiles(String remotePath, String[] autoRefreshFiles) {
        HashSet<String> newFiles = new HashSet<String>(Arrays.asList(autoRefreshFiles));
        if (autoRefreshFiles.length == DEFAULT_AUTO_REFRESH_FILES.length) {
            boolean isDefault = true;
            int i = 0;
            while (i < DEFAULT_AUTO_REFRESH_FILES.length) {
                String filePath = DEFAULT_AUTO_REFRESH_FILES[i];
                if (!newFiles.contains(new Path(null, remotePath).append(filePath).toString())) {
                    isDefault = false;
                    break;
                }
                ++i;
            }
            if (isDefault) {
                this.autoRefreshFiles.remove(remotePath);
                return;
            }
        }
        this.autoRefreshFiles.put(remotePath, newFiles);
    }

    public CVSTag[] refreshDefinedTags(ICVSFolder folder, boolean recurse, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, recurse ? 210 : 100);
        try {
            CVSTag[] tags = null;
            if (!folder.getFolderSyncInfo().isVirtualDirectory()) {
                tags = this.fetchTagsUsingAutoRefreshFiles(folder, Policy.subMonitorFor(monitor, 50));
            }
            if (tags == null || tags.length == 0) {
                tags = this.fetchTagsUsingLog(folder, Policy.subMonitorFor(monitor, 50));
            }
            if (tags != null && tags.length > 0) {
                String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)folder);
                this.addTags(remotePath, tags);
                CVSTag[] cVSTagArray = tags;
                return cVSTagArray;
            }
            if (recurse) {
                HashSet<CVSTag> tagsSet = new HashSet<CVSTag>();
                folder.fetchChildren(Policy.subMonitorFor(monitor, 10));
                ICVSResource[] children = folder.members(2);
                int i = 0;
                while (i < children.length) {
                    tagsSet.addAll(Arrays.asList(this.refreshDefinedTags((ICVSFolder)children[i], recurse, Policy.subMonitorFor(monitor, 100 / children.length))));
                    ++i;
                }
                tags = tagsSet.toArray(new CVSTag[tagsSet.size()]);
            }
            CVSTag[] cVSTagArray = tags;
            return cVSTagArray;
        }
        finally {
            monitor.done();
        }
    }

    private CVSTag[] fetchTagsUsingLog(ICVSFolder folder, IProgressMonitor monitor) throws CVSException {
        RemoteLogOperation.LogEntryCache logEntries = new RemoteLogOperation.LogEntryCache();
        RemoteLogOperation operation = new RemoteLogOperation(null, new ICVSRemoteResource[]{this.asRemoteResource(folder)}, null, null, logEntries){

            @Override
            protected Command.LocalOption[] getLocalOptions(CVSTag tag1, CVSTag tag2) {
                Command.LocalOption[] options = new Command.LocalOption[]{};
                Command.LocalOption[] newOptions = new Command.LocalOption[options.length + 1];
                System.arraycopy(options, 0, newOptions, 0, options.length);
                newOptions[options.length] = Command.DO_NOT_RECURSE;
                return newOptions;
            }
        };
        try {
            operation.run(monitor);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {}
        String[] keys = logEntries.getCachedFilePaths();
        HashSet<CVSTag> tags = new HashSet<CVSTag>();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            ILogEntry[] entries = logEntries.getLogEntries(key);
            int j = 0;
            while (j < entries.length) {
                ILogEntry entry = entries[j];
                tags.addAll(Arrays.asList(entry.getTags()));
                ++j;
            }
            ++i;
        }
        return tags.toArray(new CVSTag[tags.size()]);
    }

    private ICVSRemoteResource asRemoteResource(ICVSFolder folder) throws CVSException {
        if (folder instanceof ICVSRemoteResource) {
            return (ICVSRemoteResource)folder;
        }
        return CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)folder);
    }

    private CVSTag[] fetchTagsUsingAutoRefreshFiles(ICVSFolder folder, IProgressMonitor monitor) throws TeamException {
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)folder);
        String[] filesToRefresh = this.getAutoRefreshFiles(remotePath);
        try {
            monitor.beginTask(null, filesToRefresh.length * 10);
            ArrayList<CVSTag> tags = new ArrayList<CVSTag>();
            int i = 0;
            while (i < filesToRefresh.length) {
                block7: {
                    ICVSRemoteFile file = this.root.getRemoteFile(filesToRefresh[i], CVSTag.DEFAULT);
                    try {
                        tags.addAll(Arrays.asList(this.fetchTags(file, Policy.subMonitorFor(monitor, 5))));
                    }
                    catch (TeamException e) {
                        IStatus[] children;
                        IStatus status = e.getStatus();
                        boolean doesNotExist = false;
                        if (status.getCode() == -10 && status.isMultiStatus() && (children = status.getChildren()).length == 1 && children[0].getCode() == -17) {
                            doesNotExist = true;
                        }
                        if (doesNotExist) break block7;
                        throw e;
                    }
                }
                ++i;
            }
            CVSTag[] cVSTagArray = tags.toArray(new CVSTag[tags.size()]);
            return cVSTagArray;
        }
        finally {
            monitor.done();
        }
    }

    private CVSTag[] fetchTags(ICVSRemoteFile file, IProgressMonitor monitor) throws TeamException {
        HashSet<CVSTag> tagSet = new HashSet<CVSTag>();
        ILogEntry[] entries = file.getLogEntries(monitor);
        int j = 0;
        while (j < entries.length) {
            CVSTag[] tags = entries[j].getTags();
            int k = 0;
            while (k < tags.length) {
                tagSet.add(tags[k]);
                ++k;
            }
            ++j;
        }
        return tagSet.toArray(new CVSTag[0]);
    }

    private TagCacheEntry getTagCacheEntryFor(String remotePath, boolean create) {
        String[] segments = new Path(null, remotePath).segments();
        TagCacheEntry currentTagCacheEntry = this.rootTagCacheEntry;
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            if (currentTagCacheEntry.children.containsKey(segment)) {
                currentTagCacheEntry = (TagCacheEntry)currentTagCacheEntry.children.get(segment);
            } else {
                if (!create) {
                    return null;
                }
                TagCacheEntry newTagCacheEntry = new TagCacheEntry(new Path(null, remotePath).removeLastSegments(segments.length - (i + 1)), currentTagCacheEntry);
                currentTagCacheEntry.children.put(segment, newTagCacheEntry);
                currentTagCacheEntry = newTagCacheEntry;
            }
            ++i;
        }
        return currentTagCacheEntry;
    }

    private TagCacheEntry getKnownParentTagCacheEntryFor(String remotePath) {
        String[] segments = new Path(null, remotePath).segments();
        TagCacheEntry currentTagCacheEntry = this.rootTagCacheEntry;
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            if (!currentTagCacheEntry.children.containsKey(segment)) break;
            currentTagCacheEntry = (TagCacheEntry)currentTagCacheEntry.children.get(segment);
            ++i;
        }
        return currentTagCacheEntry;
    }

    private void removeTagsFromChildrenCacheEntries(TagCacheEntry entry, CVSTag[] tags) {
        int i = 0;
        while (i < tags.length) {
            this.removeTagFromChildrenCacheEntries(entry, tags[i]);
            ++i;
        }
        entry.getTags().removeAll(Arrays.asList(tags));
        if (entry.isEmpty()) {
            this.removeTagCacheEntry(entry);
        }
    }

    private void removeTagCacheEntry(TagCacheEntry entry) {
        if (entry.parent == null) {
            return;
        }
        HashMap newParentChildren = new HashMap();
        newParentChildren.putAll(entry.parent.children);
        newParentChildren.remove(entry.path.lastSegment());
        entry.parent.children = newParentChildren;
        if (entry.parent.isEmpty()) {
            this.removeTagCacheEntry(entry.parent);
        }
    }

    private void removeTagFromChildrenCacheEntries(TagCacheEntry entry, CVSTag tag) {
        Iterator childrenIterator = entry.getChildrenIterator();
        while (childrenIterator.hasNext()) {
            TagCacheEntry child = (TagCacheEntry)childrenIterator.next();
            this.removeTagFromChildrenCacheEntries(child, tag);
            child.getTags().remove(tag);
            if (!child.isEmpty()) continue;
            this.removeTagCacheEntry(child);
        }
    }

    public void writeState(XMLWriter writer) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.clear();
        attributes.put("id", this.root.getLocation(false));
        if (this.name != null) {
            attributes.put("name", this.name);
        }
        writer.startTag("repository", attributes, true);
        if (!this.dateTags.isEmpty()) {
            writer.startTag("date-tags", attributes, true);
            for (CVSTag tag : this.dateTags) {
                this.writeATag(writer, attributes, tag, "date-tag");
            }
            writer.endTag("date-tags");
        }
        String[] paths = this.getKnownRemotePaths();
        int i = 0;
        while (i < paths.length) {
            Set refreshSet;
            boolean writeOutTags;
            String path = paths[i];
            attributes.clear();
            String name = path;
            if (RepositoryRoot.isDefinedModuleName(path)) {
                name = RepositoryRoot.getDefinedModuleName(path);
                attributes.put("type", "defined");
            }
            attributes.put("path", name);
            TagCacheEntry entry = this.getTagCacheEntryFor(path, false);
            boolean bl = writeOutTags = entry != null && !entry.isExpired();
            if (writeOutTags) {
                attributes.put("lastAcessTime", Long.toString(entry.lastAccessTime));
            }
            writer.startTag("module", attributes, true);
            if (writeOutTags) {
                for (CVSTag tag : entry.getTags()) {
                    this.writeATag(writer, attributes, tag, "tag");
                }
            }
            if ((refreshSet = (Set)this.autoRefreshFiles.get(path)) != null) {
                for (String filename : refreshSet) {
                    attributes.clear();
                    attributes.put("full-path", filename);
                    writer.startAndEndTag("auto-refresh-file", attributes, true);
                }
            }
            writer.endTag("module");
            ++i;
        }
        writer.endTag("repository");
    }

    private void writeATag(XMLWriter writer, HashMap attributes, CVSTag tag, String s) {
        attributes.clear();
        attributes.put("name", tag.getName());
        attributes.put("type", RepositoriesViewContentHandler.TAG_TYPES[tag.getType()]);
        writer.startAndEndTag(s, attributes, true);
    }

    private void addAllKnownTagsForParents(TagCacheEntry entry, Set tags) {
        if (entry.parent != null) {
            this.addAllKnownTagsForParents(entry.parent, tags);
        }
        tags.addAll(entry.getTags());
    }

    private void addAllKnownTagsForChildren(TagCacheEntry entry, Set tags) {
        Iterator childrenIterator = entry.getChildrenIterator();
        while (childrenIterator.hasNext()) {
            TagCacheEntry child = (TagCacheEntry)childrenIterator.next();
            this.addAllKnownTagsForChildren(child, tags);
        }
        tags.addAll(entry.getTags());
    }

    public CVSTag[] getAllKnownTags(String remotePath) {
        HashSet tags = new HashSet(this.dateTags);
        this.addAllKnownTagsForParents(this.getKnownParentTagCacheEntryFor(remotePath), tags);
        TagCacheEntry entry = this.getTagCacheEntryFor(remotePath, false);
        if (entry != null) {
            this.addAllKnownTagsForChildren(entry, tags);
        }
        return tags.toArray(new CVSTag[tags.size()]);
    }

    public CVSTag[] getAllKnownTags() {
        HashSet tags = new HashSet(this.dateTags);
        this.addAllKnownTagsForChildren(this.rootTagCacheEntry, tags);
        return tags.toArray(new CVSTag[tags.size()]);
    }

    public String[] getRemoteChildrenForTag(String remotePath, CVSTag tag) {
        TagCacheEntry entry = remotePath == null ? this.rootTagCacheEntry : this.getTagCacheEntryFor(remotePath, false);
        if (entry == null) {
            return new String[0];
        }
        HashSet<String> paths = new HashSet<String>();
        Iterator childrenIterator = entry.getChildrenIterator();
        while (childrenIterator.hasNext()) {
            TagCacheEntry child = (TagCacheEntry)childrenIterator.next();
            HashSet childTags = new HashSet();
            this.addAllKnownTagsForChildren(child, childTags);
            if (!childTags.contains(tag)) continue;
            paths.add(child.path.toString());
        }
        return paths.toArray(new String[paths.size()]);
    }

    private Set getKnownRemotePaths(TagCacheEntry entry) {
        HashSet<String> paths = new HashSet<String>();
        Iterator childrenIterator = entry.getChildrenIterator();
        while (childrenIterator.hasNext()) {
            paths.addAll(this.getKnownRemotePaths((TagCacheEntry)childrenIterator.next()));
        }
        paths.add(entry.path.toString());
        return paths;
    }

    public String[] getKnownRemotePaths() {
        Set paths = this.getKnownRemotePaths(this.rootTagCacheEntry);
        paths.addAll(this.autoRefreshFiles.keySet());
        return paths.toArray(new String[paths.size()]);
    }

    public Object getAdapter(Class adapter) {
        if (ICVSRepositoryLocation.class.equals((Object)adapter)) {
            return this.getRoot();
        }
        return super.getAdapter(adapter);
    }

    public boolean tagIsKnown(ICVSRemoteResource remoteResource) {
        if (remoteResource instanceof ICVSRemoteFolder) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)remoteResource;
            String path = folder.getRepositoryRelativePath();
            CVSTag[] tags = this.getAllKnownTags(path);
            CVSTag tag = folder.getTag();
            int i = 0;
            while (i < tags.length) {
                CVSTag knownTag = tags[i];
                if (knownTag.equals((Object)tag)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        Object object = this.modulesCacheLock;
        synchronized (object) {
            if (this.modulesCache != null) {
                this.modulesCache = null;
            }
        }
    }

    void setRepositoryLocation(ICVSRepositoryLocation root) {
        this.root = root;
    }

    void setLastAccessedTime(String remotePath, long lastAccessTime) {
        TagCacheEntry entry = this.getTagCacheEntryFor(remotePath, false);
        if (entry != null) {
            entry.lastAccessTime = lastAccessTime;
        }
    }

    public static class TagCacheEntry {
        IPath path;
        private Set tags = new HashSet();
        Map children = new HashMap();
        TagCacheEntry parent;
        long lastAccessTime;
        private static final int CACHE_LIFESPAN_IN_DAYS = 7;

        public TagCacheEntry(IPath path, TagCacheEntry parent) {
            this.path = path;
            this.parent = parent;
            this.accessed();
        }

        public Set getTags() {
            this.accessed();
            return this.tags;
        }

        public Iterator getChildrenIterator() {
            return this.children.values().iterator();
        }

        public boolean isEmpty() {
            return this.getTags().isEmpty() && this.children.isEmpty();
        }

        public boolean isExpired() {
            long currentTime = System.currentTimeMillis();
            long ms = currentTime - this.lastAccessTime;
            int seconds = (int)ms / 1000;
            int hours = seconds / 60 / 60;
            int days = hours / 24;
            return days > 7;
        }

        private void accessed() {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }
}

