/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.services.AbstractUIActivator;
import org.polarsys.capella.core.commands.preferences.service.AbstractPreferencesInitializer;
import org.polarsys.capella.core.ui.properties.preferences.CapellaUIPropertiesPreferencesInitializer;
import org.polarsys.capella.core.ui.properties.preferences.ITransfertViewerPreferences;
import org.polarsys.capella.core.ui.properties.sections.IAbstractSection;
import org.polarsys.capella.core.ui.properties.wizards.CustomPropertyHelper;
import org.polarsys.capella.core.ui.properties.wizards.CustomWizardHandler;
import org.polarsys.capella.core.ui.properties.wizards.ICustomWizardHandler;
import org.polarsys.capella.core.ui.properties.wizards.OpenCustomWizardCommand;

public class CapellaUIPropertiesPlugin
extends AbstractUIActivator {
    public static final String PLUGIN_ID = "org.polarsys.capella.core.ui.properties";
    public static final String PROPERTIES_CONTRIBUTOR = "org.polarsys.capella.core.data.capellamodeller.properties";
    public static final String PROPERTIES_SHEET_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    private static CapellaUIPropertiesPlugin __plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
        new CapellaUIPropertiesPreferencesInitializer();
    }

    public void stop(BundleContext context) throws Exception {
        __plugin = null;
        super.stop(context);
    }

    public static CapellaUIPropertiesPlugin getDefault() {
        return __plugin;
    }

    public ICustomWizardHandler getCustomWizardHandler() {
        return new CustomWizardHandler();
    }

    private boolean openCustomWizard(EObject object) {
        OpenCustomWizardCommand command = new OpenCustomWizardCommand(object);
        TransactionHelper.getExecutionManager((EObject)object).execute((ICommand)command);
        return !command.isCanceled();
    }

    public boolean openWizard(DoubleClickEvent event, EObject object) {
        boolean result = false;
        if (CapellaUIPropertiesPlugin.existCustomWizard(object)) {
            result = this.openCustomWizard(object);
        }
        return result;
    }

    public boolean openWizard(EObject object) {
        return this.openWizard(null, object);
    }

    public static boolean existCustomWizard(EObject eclass) {
        Map<String, IAbstractSection> sections = CustomPropertyHelper.getCustomPropertySection(eclass, PROPERTIES_CONTRIBUTOR);
        return !sections.isEmpty();
    }

    public boolean isAllowedExpandLeftViewerContent() {
        return AbstractPreferencesInitializer.getBoolean((String)"expand.left.viewer.content", (boolean)ITransfertViewerPreferences.PREFS_EXPAND_LEFT_VIEWER_CONTENT_DEFAULT);
    }

    public boolean isAllowedExpandRightViewerContent() {
        return AbstractPreferencesInitializer.getBoolean((String)"expand.right.viewer.content", (boolean)ITransfertViewerPreferences.PREFS_EXPAND_RIGHT_VIEWER_CONTENT_DEFAULT);
    }

    public boolean isAllowedExpandSingleViewerContent() {
        return AbstractPreferencesInitializer.getBoolean((String)"expand.single.viewer.content", (boolean)ITransfertViewerPreferences.PREFS_EXPAND_SINGLE_VIEWER_CONTENT_DEFAULT);
    }

    public boolean isDisableLabelComputation() {
        return AbstractPreferencesInitializer.getBoolean((String)"disable.label.computation", (boolean)ITransfertViewerPreferences.PREFS_DISABLE_LABEL_COMPUTATION_DEFAULT);
    }
}

