/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.providers;

import java.text.MessageFormat;
import java.util.Collection;
import org.polarsys.capella.core.ui.properties.providers.CapellaTransfertViewerLabelProvider;

public class DependencyLabelProvider
extends CapellaTransfertViewerLabelProvider {
    public static final String FMT_DEFAULT = "{1}";
    public static final String FMT_DEPENDS = "{0} --> {1}";
    public static final String FMT_INVERSE_DEPENDS = "{0} <-- {1}";
    public static final String FMT_CYCLE = "{0} <--> {1}";
    protected Collection<?> dependencies;
    protected Collection<?> inverseDependencies;
    protected Object subject;
    protected String subjectText;

    public DependencyLabelProvider(Collection<?> dependencies, Collection<?> inverseDependencies, Object subject) {
        this.dependencies = dependencies;
        this.inverseDependencies = inverseDependencies;
        this.subject = subject;
    }

    protected String getSubjectText() {
        if (this.subjectText == null) {
            this.subjectText = super.getText(this.subject);
        }
        return this.subjectText;
    }

    @Override
    public String getText(Object element) {
        String left = this.getSubjectText();
        String right = super.getText(element);
        String fmt = FMT_DEFAULT;
        if (this.dependencies.contains(element) && this.inverseDependencies.contains(element)) {
            fmt = FMT_CYCLE;
        } else if (this.dependencies.contains(element)) {
            fmt = FMT_DEPENDS;
        } else if (this.inverseDependencies.contains(element)) {
            fmt = FMT_INVERSE_DEPENDS;
        }
        return MessageFormat.format(fmt, left, right);
    }
}

