/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.query.legacy.ecore.factories.EFactory;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.SpecificScript;
import org.eclipse.sirius.query.legacy.tools.resources.FileContentMap;

public class EObjectServices {
    protected IScript script;
    private Map eAllContents = new WeakHashMap();
    private List eRootPackages = new ArrayList();
    private Map eClass2containments = new HashMap();
    private Map eClass2subTypes = null;
    private FileContentMap load = new FileContentMap();

    public EObjectServices() {
    }

    public EObjectServices(IScript script) {
        this.script = script;
        if (script instanceof SpecificScript) {
            this.addMetamodel(((SpecificScript)script).getMetamodel());
        }
    }

    protected void addMetamodel(EPackage metamodel) {
        if (!this.eRootPackages.contains(metamodel)) {
            this.listClassifiers(metamodel);
            this.eRootPackages.add(metamodel);
        }
    }

    public EObject eContainer(EObject current) {
        return current.eContainer();
    }

    public EObject eContainer(EObject current, String type) throws FactoryException {
        while (current != null) {
            if (EFactory.eInstanceOf(current, type)) {
                return current;
            }
            current = current.eContainer();
        }
        return null;
    }

    public EObject getRootContainer(EObject eObject) {
        return EcoreUtil.getRootContainer((EObject)eObject);
    }

    public EObject eClass(EObject current) {
        return current.eClass();
    }

    public EList eContents(EObject current) {
        return current.eContents();
    }

    public ENodeList eAllContents(ENode current) {
        ENodeList result = new ENodeList();
        try {
            if (current.isList()) {
                ENodeIterator it = current.getList().iterator();
                while (it.hasNext()) {
                    result.addAll(this.eAllContents(it.next()));
                }
            } else if (current.isEObject()) {
                TreeIterator it = current.getEObject().eAllContents();
                while (it.hasNext()) {
                    result.add(ENode.createTry(it.next(), current));
                }
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        return result;
    }

    public ENodeList eAllContents(ENode current, String type) throws FactoryException {
        ENodeList result = new ENodeList();
        try {
            if (current.isList()) {
                ENodeIterator it = current.getList().iterator();
                while (it.hasNext()) {
                    result.addAll(this.eAllContents(it.next(), type));
                }
            } else if (current.isEObject()) {
                StringBuffer buffer = new StringBuffer();
                Resource eResource = current.getEObject().eResource();
                if (eResource != null) {
                    buffer.append(eResource.getURI().path());
                    buffer.append(':');
                    buffer.append(eResource.getURIFragment(current.getEObject()));
                } else {
                    buffer.append(':');
                    buffer.append(ETools.getURI(current.getEObject()));
                }
                buffer.append(':');
                buffer.append(type);
                String uri = buffer.toString();
                List children = (List)this.eAllContents.get(uri);
                if (children == null) {
                    int i = type.lastIndexOf(".");
                    String typeName = i > -1 ? type.substring(i + 1) : type;
                    children = this.eAllContents(current.getEObject(), type, typeName);
                    this.eAllContents.put(uri, children);
                }
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    result.add(ENode.createTry(it.next(), current));
                }
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        return result;
    }

    private List eAllContents(EObject object, String type, String typeName) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        List containmentTypeNames = this.getContainmentNames(object);
        if (containmentTypeNames.contains(typeName)) {
            for (EObject eContent : object.eContents()) {
                if (EFactory.eInstanceOf(eContent, type)) {
                    result.add(eContent);
                }
                result.addAll(this.eAllContents(eContent, type, typeName));
            }
        }
        return result;
    }

    private List getContainmentNames(EObject object) {
        EClass eClass = object.eClass();
        EPackage ePackage = (EPackage)this.getRootContainer((EObject)eClass);
        this.addMetamodel(ePackage);
        String eClassName = eClass.getName();
        ArrayList containmentNames = (ArrayList)this.eClass2containments.get(eClassName);
        if (containmentNames == null) {
            containmentNames = new ArrayList();
            this.computeContainments(new ArrayList(), containmentNames, ePackage, (List)eClass.getEAllReferences());
            this.eClass2containments.put(eClassName, containmentNames);
        }
        return containmentNames;
    }

    private void computeContainments(List containmentTypes, List containmentNames, EPackage ePackage, List eReferences) {
        for (EReference eReference : eReferences) {
            if (!eReference.isContainment()) continue;
            HashSet<EClassifier> types = new HashSet<EClassifier>();
            types.add(eReference.getEType());
            if (eReference.getEType() instanceof EClass) {
                types.addAll((Collection<EClassifier>)((EClass)eReference.getEType()).getEAllSuperTypes());
            }
            for (EClassifier subType : this.eClass2subTypes(ePackage, eReference.getEType())) {
                types.add(subType);
                if (!(subType instanceof EClass)) continue;
                for (EClassifier superType : ((EClass)subType).getEAllSuperTypes()) {
                    String name = superType.getName();
                    if (containmentNames.contains(name)) continue;
                    containmentNames.add(name);
                }
            }
            for (EClassifier type : types) {
                if (!(type instanceof EClass)) continue;
                String name = type.getName();
                if (containmentTypes.contains(type)) continue;
                containmentTypes.add(type);
                if (!containmentNames.contains(name)) {
                    containmentNames.add(name);
                }
                this.computeContainments(containmentTypes, containmentNames, ePackage, (List)((EClass)type).getEReferences());
            }
        }
    }

    private List eClass2subTypes(EPackage ePackage, EClassifier eClass) {
        ArrayList types;
        if (this.eClass2subTypes == null) {
            this.eClass2subTypes = new HashMap();
        }
        if ((types = (ArrayList)this.eClass2subTypes.get(eClass)) == null) {
            types = new ArrayList();
        }
        return types;
    }

    private void listClassifiers(EPackage ePackage) {
        Iterator classifiers = ETools.computeAllClassifiersList(ePackage, false).iterator();
        if (this.eClass2subTypes == null) {
            this.eClass2subTypes = new HashMap();
        }
        while (classifiers.hasNext()) {
            Object next = classifiers.next();
            if (!(next instanceof EClass)) continue;
            EClass c = (EClass)next;
            for (EClass superType : c.getEAllSuperTypes()) {
                ArrayList<EClass> subTypes = (ArrayList<EClass>)this.eClass2subTypes.get(superType);
                if (subTypes == null) {
                    subTypes = new ArrayList<EClass>();
                    this.eClass2subTypes.put(superType, subTypes);
                }
                if (subTypes.contains(c)) continue;
                subTypes.add(c);
            }
        }
    }

    public EStructuralFeature eContainingFeature(EObject current) {
        return current.eContainingFeature();
    }

    public EReference eContainmentFeature(EObject current) {
        return current.eContainmentFeature();
    }

    public List eCrossReferences(EObject current) {
        return current.eCrossReferences();
    }

    public String eResource(EObject current) {
        if (current != null && current.eResource() != null) {
            return current.eResource().getURI().path();
        }
        return null;
    }

    public String eResourceName(EObject current) {
        if (current != null && current.eResource() != null) {
            return current.eResource().getURI().lastSegment();
        }
        return null;
    }

    public EObject load(ENode node, String path) {
        IFile file;
        if (path.startsWith("/resource")) {
            path = path.substring("/resource".length());
        }
        if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path))).exists()) {
            EObject result = (EObject)this.load.get(file);
            if (result == null) {
                result = ETools.loadXMI(path);
                this.load.put(file, (Object)result);
            }
            return result;
        }
        return ETools.loadXMI(path);
    }
}

