/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.refinement.processor;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.interaction.RefinementLink;
import org.polarsys.capella.core.refinement.preferences.services.RefinementPrefServices;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;
import org.polarsys.capella.core.sirius.ui.actions.NewRepresentationAction;

public class DiagramCreation
implements IProcessor {
    protected ModelElement contextElement;
    protected NamedElement targetElement;

    public void execute(IProgressMonitor progressMonitor_p) throws ProcessorException {
        boolean createDiagram = RefinementPrefServices.isRefinedDiagramCreationAllowed();
        if (createDiagram && this.contextElement != null && this.targetElement != null) {
            RepresentationDescription diagramRepresentation;
            Session session;
            TraceableElement tgtElt = null;
            for (AbstractTrace trace : ((CapellaElement)this.contextElement).getIncomingTraces()) {
                TraceableElement srcElt;
                if (!(trace instanceof RefinementLink) || !EcoreUtil2.isContainedBy((EObject)(srcElt = trace.getSourceElement()), (EObject)this.targetElement)) continue;
                tgtElt = srcElt;
            }
            if (tgtElt != null && (session = SessionManager.INSTANCE.getSession(tgtElt)) != null && (diagramRepresentation = this.getDiagramRepresentation(session, (ModelElement)tgtElt)) != null && DialectManager.INSTANCE.canCreate((EObject)tgtElt, diagramRepresentation)) {
                for (DRepresentation representation : DialectManager.INSTANCE.getRepresentations((EObject)tgtElt, session)) {
                    if (!(representation instanceof DDiagram) || !diagramRepresentation.equals(((DDiagram)representation).getDescription())) continue;
                    return;
                }
                boolean openDiagram = RefinementPrefServices.isRefinedDiagramOpeningAllowed();
                NewRepresentationAction newDiagramAction = new NewRepresentationAction(diagramRepresentation, (EObject)tgtElt, session, true, openDiagram);
                newDiagramAction.run();
            }
        }
    }

    protected RepresentationDescription getDiagramRepresentation(Session session_p, ModelElement modelElement_p) {
        Collection activeViewpoints = session_p.getSelectedViewpoints(false);
        Collection diagramDescriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(activeViewpoints, (EObject)modelElement_p);
        for (RepresentationDescription diagramDescription : diagramDescriptions) {
            if (!"Component Interfaces Scenario".equals(diagramDescription.getName())) continue;
            return diagramDescription;
        }
        return null;
    }

    public Object getResult() {
        return null;
    }

    public void setContext(ModelElement context_p) {
        this.contextElement = context_p;
    }

    public void setContext(List<ModelElement> context_p) {
    }

    public void setTarget(NamedElement target_p) {
        this.targetElement = target_p;
    }

    public Object getName() {
        return "Diagram Creation";
    }
}

