/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.ui.viewer;

import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.refinement.merge.ui.viewer.ExecutionExplorer;
import org.polarsys.capella.core.refinement.merge.ui.viewer.InstanceRoleExplorer;
import org.polarsys.capella.core.refinement.merge.ui.viewer.MessageEndExplorer;
import org.polarsys.capella.core.refinement.merge.ui.viewer.MessageExplorer;

public class ScenarioExplorer
extends Composite {
    private MessageExplorer _messageExplorer = null;
    private MessageEndExplorer _abstractEndExplorer = null;
    private ExecutionExplorer _executionExplorer = null;
    private InstanceRoleExplorer _instanceRoleExplorer = null;
    private TabFolder _tabFolder = null;
    private Composite _integrity = null;
    private Text textArea = null;

    public ScenarioExplorer(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        this.create_tabFolder();
        this.setSize(new Point(570, 286));
    }

    private void create_messageExplorer() {
        this._messageExplorer = new MessageExplorer((Composite)this._tabFolder, 0x1000000);
        this._messageExplorer.setVisible(true);
        this._messageExplorer.setLayout((Layout)new FillLayout());
    }

    private void create_abstractEndExplorer() {
        this._abstractEndExplorer = new MessageEndExplorer((Composite)this._tabFolder, 0x1000000);
        this._abstractEndExplorer.setVisible(true);
        this._abstractEndExplorer.setLayout((Layout)new FillLayout());
    }

    private void create_executionExplorer() {
        this._executionExplorer = new ExecutionExplorer((Composite)this._tabFolder, 0x1000000);
        this._executionExplorer.setVisible(true);
        this._executionExplorer.setLayout((Layout)new FillLayout());
    }

    private void create_instanceRoleExplorer() {
        this._instanceRoleExplorer = new InstanceRoleExplorer((Composite)this._tabFolder, 0x1000000);
        this._instanceRoleExplorer.setVisible(true);
        this._instanceRoleExplorer.setLayout((Layout)new FillLayout());
    }

    public void setScenario(Scenario scenario) {
        EList messages = scenario.getOwnedMessages();
        for (SequenceMessage message : messages) {
            this.addMessage(message);
        }
        EList messageEnds = scenario.getOwnedInteractionFragments();
        for (InteractionFragment messageEnd : messageEnds) {
            if (!(messageEnd instanceof AbstractEnd)) continue;
            this.addAbstractEnd((AbstractEnd)messageEnd);
        }
        EList executions = scenario.getOwnedTimeLapses();
        for (TimeLapse execution : executions) {
            if (!(execution instanceof Execution)) continue;
            this.addExecution((Execution)execution);
        }
        EList instanceRoles = scenario.getOwnedInstanceRoles();
        for (InstanceRole instanceRole : instanceRoles) {
            this.addInstanceRole(instanceRole);
        }
        this.textArea.setText(this.checkIntegrity(scenario));
    }

    private String checkIntegrity(Scenario scenario) {
        StringBuilder buffer = new StringBuilder();
        return buffer.toString();
    }

    private void addInstanceRole(InstanceRole instanceRole) {
        this._instanceRoleExplorer.addInstanceRole(instanceRole);
    }

    private void addExecution(Execution execution) {
        this._executionExplorer.addExecution(execution);
    }

    public void addMessage(SequenceMessage value) {
        this._messageExplorer.addMessage(value);
    }

    public void addAbstractEnd(AbstractEnd value) {
        this._abstractEndExplorer.addAbstractEnd(value);
    }

    private void create_tabFolder() {
        this._tabFolder = new TabFolder((Composite)this, 0);
        TabItem tabItem1 = new TabItem(this._tabFolder, 0);
        this.create_integrity();
        tabItem1.setText("Scenario Integrity");
        tabItem1.setControl((Control)this._integrity);
        this.create_messageExplorer();
        TabItem tabItem = new TabItem(this._tabFolder, 0);
        tabItem.setText("Messages");
        tabItem.setControl((Control)this._messageExplorer);
        this.create_abstractEndExplorer();
        TabItem tabItem2 = new TabItem(this._tabFolder, 0);
        tabItem2.setText("Abstract Ends");
        tabItem2.setControl((Control)this._abstractEndExplorer);
        this.create_executionExplorer();
        TabItem tabItem3 = new TabItem(this._tabFolder, 0);
        tabItem3.setText("Executions");
        tabItem3.setControl((Control)this._executionExplorer);
        this.create_instanceRoleExplorer();
        TabItem tabItem4 = new TabItem(this._tabFolder, 0);
        tabItem4.setText("Instance Roles");
        tabItem4.setControl((Control)this._instanceRoleExplorer);
    }

    private void create_integrity() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this._integrity = new Composite((Composite)this._tabFolder, 0);
        this._integrity.setLayout((Layout)new GridLayout());
        this.textArea = new Text(this._integrity, 578);
        this.textArea.setLayoutData((Object)gridData);
    }
}

