/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.menu.dynamic.CreationHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.RefinementLink;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class RefinementLinkExt {
    private static final Logger _logger = ReportManagerRegistry.getInstance().subscribe("Model Management");

    public static RefinementLink createRefinementTraceabilityLink(NamedElement sourceElt, NamedElement targetElt) {
        return RefinementLinkExt.createRefinementTraceabilityLink(sourceElt, targetElt, sourceElt);
    }

    public static RefinementLink createRefinementTraceabilityLink(NamedElement sourceElt, NamedElement targetElt, NamedElement container) {
        RefinementLink lnk = null;
        Namespace ownerElt = (Namespace)(container instanceof Namespace ? container : EcoreUtil2.getFirstContainer((EObject)container, (EClass)CapellacorePackage.Literals.NAMESPACE));
        if (ownerElt != null) {
            lnk = RefinementLinkExt.createRefinementTraceabilityLink(sourceElt, targetElt, ownerElt);
        } else {
            _logger.debug((Object)new EmbeddedMessage("The traceability between '" + sourceElt.getName() + "' and '" + targetElt.getName() + "' have no container.", "Model Management"));
        }
        return lnk;
    }

    public static RefinementLink createRefinementTraceabilityLink(NamedElement sourceElt, NamedElement targetElt, Namespace container) {
        RefinementLink lnk = null;
        if (container != null) {
            lnk = InteractionFactory.eINSTANCE.createRefinementLink();
            lnk.setSourceElement((TraceableElement)sourceElt);
            lnk.setTargetElement((TraceableElement)targetElt);
            container.getOwnedTraces().add((Object)lnk);
            CreationHelper.performContributionCommands((EObject)sourceElt, (EObject)container);
        }
        return lnk;
    }

    public static List<EObject> getInvalidAttachedToBestElement(EObject sourceElt, EReference reference) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        if (reference.isMany()) {
            for (Object obj : (List)sourceElt.eGet((EStructuralFeature)reference)) {
                if (obj == null || !(obj instanceof EObject) || RefinementLinkExt.isAttachedToBestElement(sourceElt, (EObject)obj)) continue;
                list.add((EObject)obj);
            }
        } else {
            Object obj = sourceElt.eGet((EStructuralFeature)reference);
            if (obj != null && obj instanceof EObject && !RefinementLinkExt.isAttachedToBestElement(sourceElt, (EObject)obj)) {
                list.add((EObject)obj);
            }
        }
        return list;
    }

    public static List<Object> getMissingValuesFromRefined(EObject sourceElt, EAttribute attribute, Collection<?> excludeValuesFromSources) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (AbstractTrace lnk : ((TraceableElement)sourceElt).getOutgoingTraces()) {
            Object obj2;
            TraceableElement target = lnk.getTargetElement();
            if (target == null || !EcoreUtil2.isEqualOrSuperClass((EClass)target.eClass(), (EClass)sourceElt.eClass())) continue;
            if (attribute.isMany()) {
                for (Object obj2 : (List)target.eGet((EStructuralFeature)attribute)) {
                    if (obj2 == null || excludeValuesFromSources.contains(obj2) || ((List)sourceElt.eGet((EStructuralFeature)attribute)).contains(obj2)) continue;
                    list.add(obj2);
                }
                continue;
            }
            obj2 = target.eGet((EStructuralFeature)attribute);
            if (obj2 == null || excludeValuesFromSources.contains(obj2) || obj2.equals(sourceElt.eGet((EStructuralFeature)attribute))) continue;
            list.add(obj2);
        }
        return list;
    }

    public static List<CapellaElement> getRefinementRelatedSourceElements(CapellaElement currentElt, EClass type) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        if (currentElt != null) {
            for (AbstractTrace lnk : currentElt.getIncomingTraces()) {
                TraceableElement elt;
                if (!(lnk instanceof RefinementLink) || !((elt = lnk.getSourceElement()) instanceof CapellaElement) || !type.isSuperTypeOf(elt.eClass()) || result.contains(elt)) continue;
                result.add((CapellaElement)elt);
            }
        }
        return result;
    }

    public static List<CapellaElement> getRefinementRelatedTargetElements(CapellaElement currentElt, EClass type) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        if (currentElt != null) {
            for (AbstractTrace lnk : currentElt.getOutgoingTraces()) {
                TraceableElement elt;
                if (!(lnk instanceof RefinementLink) || !((elt = lnk.getTargetElement()) instanceof CapellaElement) || !type.isSuperTypeOf(elt.eClass()) || result.contains(elt)) continue;
                result.add((CapellaElement)elt);
            }
        }
        return result;
    }

    public static List<CapellaElement> getRelatedSourceElements(CapellaElement currentElt, EClass type) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        if (currentElt != null) {
            for (AbstractTrace lnk : currentElt.getIncomingTraces()) {
                TraceableElement elt = lnk.getSourceElement();
                if (!(elt instanceof CapellaElement) || !type.isSuperTypeOf(elt.eClass()) || result.contains(elt)) continue;
                result.add((CapellaElement)elt);
            }
        }
        return result;
    }

    public static List<CapellaElement> getRelatedTargetElements(CapellaElement currentElt, EClass type) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        if (currentElt != null) {
            for (AbstractTrace lnk : currentElt.getOutgoingTraces()) {
                TraceableElement elt = lnk.getTargetElement();
                if (!(elt instanceof CapellaElement) || !type.isSuperTypeOf(elt.eClass()) || result.contains(elt)) continue;
                result.add((CapellaElement)elt);
            }
        }
        return result;
    }

    public static boolean hasMissingValuesFromRefined(EObject sourceElt, EAttribute attribute, Collection<?> excludeValuesFromSources) {
        return RefinementLinkExt.getMissingValuesFromRefined(sourceElt, attribute, excludeValuesFromSources).size() > 0;
    }

    public static boolean isAttachedToBestElement(EObject sourceElt, EObject objValue) {
        return CapellaLayerCheckingExt.areInSameLayer(sourceElt, objValue) || !RefinementLinkExt.isTransitionedInto(objValue, BlockArchitectureExt.getRootBlockArchitecture(sourceElt));
    }

    public static boolean isLinkedTo(TraceableElement sourceElt, TraceableElement targetElt) {
        if (sourceElt != null) {
            for (AbstractTrace lnk : sourceElt.getOutgoingTraces()) {
                TraceableElement target = lnk.getTargetElement();
                if (target == null || !target.equals(targetElt)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTransitionedInto(EObject sourceElt, BlockArchitecture rootBlockArchitecture) {
        if (sourceElt != null && sourceElt instanceof TraceableElement) {
            for (AbstractTrace lnk : ((TraceableElement)sourceElt).getIncomingTraces()) {
                TraceableElement target = lnk.getSourceElement();
                if (target == null || !rootBlockArchitecture.equals(BlockArchitectureExt.getRootBlockArchitecture((EObject)target))) continue;
                return true;
            }
        }
        return false;
    }
}

