/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.InterModelInconsistency;

public class DependencyViolation
implements InterModelInconsistency {
    protected EObject source;
    protected EObject target;
    protected EReference reference;
    protected List<EObject> involvedObjects;

    public DependencyViolation(EObject source, EObject target, EReference reference) {
        this.source = source;
        this.target = target;
        this.involvedObjects = new ArrayList<EObject>();
        this.involvedObjects.add(source);
        this.involvedObjects.add(target);
        this.reference = reference;
    }

    @Override
    public List<EObject> getInvolvedObjects() {
        return this.involvedObjects;
    }

    public EObject getSource() {
        return this.source;
    }

    public EObject getTarget() {
        return this.target;
    }

    public EReference getEReference() {
        return this.reference;
    }

    @Override
    public String getTypeName() {
        return "dependency violation";
    }

    public String getViolatedDependencyDescription() {
        IModel sourceModel = ILibraryManager.INSTANCE.getModel(this.source);
        IModel targetModel = ILibraryManager.INSTANCE.getModel(this.target);
        return String.valueOf(sourceModel.getIdentifier().getName()) + " -> " + targetModel.getIdentifier().getName();
    }

    public String getDescription() {
        String sourceModelName = ILibraryManager.INSTANCE.getModel(this.source).getIdentifier().getName();
        String targetModelName = ILibraryManager.INSTANCE.getModel(this.target).getIdentifier().getName();
        String referenceName = this.reference != null ? this.reference.getName() : null;
        String description = "'" + EObjectLabelProviderHelper.getText((EObject)this.source) + "'[" + this.source.eClass().getName() + "] (in model '" + sourceModelName + "') targets '" + EObjectLabelProviderHelper.getText((EObject)this.target) + "'[" + this.target.eClass().getName() + "] (in model '" + targetModelName + "')";
        if (referenceName != null) {
            description = String.valueOf(description) + " via reference '" + referenceName + "'";
        }
        return description;
    }
}

