/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.requirement.Requirement;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.Messages;
import org.polarsys.capella.core.sirius.analysis.tool.StringUtil;

public class RequirementServices {
    private static RequirementServices service = null;

    public static RequirementServices getService() {
        if (service == null) {
            service = new RequirementServices();
        }
        return service;
    }

    public String getRFLabel(EObject context_p, EObject line, EObject column) {
        if (column != null && column instanceof AbstractFunction && line instanceof Requirement) {
            for (AbstractTrace trace : ((Requirement)line).getIncomingTraces()) {
                if (!column.equals(trace.getSourceElement())) continue;
                return "X";
            }
        }
        return "";
    }

    public String getRequirementElementLabel(NamedElement requirment_p) {
        Requirement requirment;
        if (requirment_p instanceof Requirement && !StringUtil.isNullOrEmpty((requirment = (Requirement)requirment_p).getRequirementId())) {
            return NLS.bind((String)Messages.Requirement_Label, (Object)requirment.getRequirementId(), (Object)requirment.getName());
        }
        return requirment_p.getName();
    }

    public Collection<EObject> getRFColumnCandidates(EObject source_p) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)source_p);
        List functions = FunctionExt.getAllAbstractFunctions((BlockArchitecture)architecture);
        if (architecture.getOwnedFunctionPkg() != null) {
            functions.removeAll(FunctionPkgExt.getOwnedFunctions((FunctionPkg)architecture.getOwnedFunctionPkg()));
        }
        return functions;
    }
}

