/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.editpart;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class RotativeWorkspaceImageFigure
extends WorkspaceImageFigure {
    private static Map<String, Image> cache = new HashMap<String, Image>();
    private String path;
    private Image root;
    private int mode = 0;
    private final int FOUR_IMAGES = 0;
    private final int ROTATIVE = 1;

    public RotativeWorkspaceImageFigure(String path_p) {
        super(RotativeWorkspaceImageFigure.flyWeightImage((String)path_p));
        this.path = path_p;
        this.root = RotativeWorkspaceImageFigure.flyWeightImage((String)path_p);
        this.mode = 1;
    }

    public RotativeWorkspaceImageFigure(String path_p, Image top, Image left, Image bottom, Image right) {
        super(top);
        cache.put(String.valueOf(path_p) + "_top", top);
        cache.put(String.valueOf(path_p) + "_bottom", bottom);
        cache.put(String.valueOf(path_p) + "_left", left);
        cache.put(String.valueOf(path_p) + "_right", right);
        this.mode = 0;
    }

    private Image rotate(Image image, int direction) {
        ImageData srcData = image.getImageData();
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = direction == 1024 ? srcData.width * bytesPerPixel : srcData.height * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        boolean isAlpha = srcData.alphaData != null;
        byte[] newAlphaData = null;
        if (isAlpha) {
            newAlphaData = new byte[srcData.alphaData.length];
        }
        ImageData imgData = new ImageData(direction == 1024 ? srcData.width : srcData.height, direction == 1024 ? srcData.height : srcData.width, srcData.depth, srcData.palette, destBytesPerLine, newData);
        if (isAlpha) {
            imgData.alphaData = newAlphaData;
        }
        imgData.alpha = srcData.alpha;
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = 0;
                int destY = 0;
                switch (direction) {
                    case 16384: {
                        destX = srcY;
                        destY = srcData.width - srcX - 1;
                        break;
                    }
                    case 131072: {
                        destX = srcData.height - srcY - 1;
                        destY = srcX;
                        break;
                    }
                    case 1024: {
                        destX = srcData.width - srcX - 1;
                        destY = srcData.height - srcY - 1;
                    }
                }
                imgData.setPixel(destX, destY, srcData.getPixel(srcX, srcY));
                if (isAlpha) {
                    imgData.setAlpha(destX, destY, srcData.getAlpha(srcX, srcY));
                }
                ++srcX;
            }
            ++srcY;
        }
        return new Image(image.getDevice(), imgData);
    }

    public Image getRightImage() {
        Image img = cache.get(String.valueOf(this.path) + "_right");
        if (img == null && this.mode == 1) {
            img = this.rotate(this.root, 131072);
            cache.put(String.valueOf(this.path) + "_right", img);
        }
        return img;
    }

    public Image getLeftImage() {
        Image img = cache.get(String.valueOf(this.path) + "_left");
        if (img == null && this.mode == 1) {
            img = this.rotate(this.root, 16384);
            cache.put(String.valueOf(this.path) + "_left", img);
        }
        return img;
    }

    public Image getBottomImage() {
        Image img = cache.get(String.valueOf(this.path) + "_bottom");
        if (img == null && this.mode == 1) {
            img = this.rotate(this.root, 1024);
            cache.put(String.valueOf(this.path) + "_bottom", img);
        }
        return img;
    }

    public Image getTopImage() {
        return this.root;
    }

    public void setImage(Image image) {
        super.setImage(image);
    }

    public void refreshFigure(WorkspaceImage bundledImage) {
        if (this.path != bundledImage.getWorkspacePath()) {
            this.path = bundledImage.getWorkspacePath();
            this.root = RotativeWorkspaceImageFigure.flyWeightImage((String)this.path);
            this.setImage(this.root);
        }
        this.repaint();
    }

    public void refreshFigure(ContainerStyle containerStyle) {
        if (containerStyle instanceof WorkspaceImage) {
            this.refreshFigure((WorkspaceImage)containerStyle);
        }
    }
}

