/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABComponentPortAllocation;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideABPhysicalCategory
extends ShowHideABComponentPortAllocation {
    public static final String NO_SOURCE_PORT = "npo";
    public static final String NO_TARGET_PORT = "npo";
    public static final String SOURCE_PORTS = "spo";
    public static final String TARGET_PORTS = "tpo";

    public ShowHideABPhysicalCategory(DDiagramContents content_p) {
        super(content_p);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof PhysicalLinkCategory) {
            if ("source".equals(lastContext.getKey())) {
                AbstractShowHide.ContextItemVariable variable = context_p.getLastVariable("sourceParts");
                if (variable != null && variable.getValue() instanceof Collection) {
                    value.putAll("container", (Collection)variable.getValue());
                }
            } else if ("target".equals(lastContext.getKey())) {
                AbstractShowHide.ContextItemVariable variable = context_p.getLastVariable("targetParts");
                if (variable != null && variable.getValue() instanceof Collection) {
                    value.putAll("container", (Collection)variable.getValue());
                }
            } else {
                AbstractShowHide.ContextItemVariable noSourcePort = context_p.getLastVariable("npo");
                AbstractShowHide.ContextItemVariable noTargetPort = context_p.getLastVariable("npo");
                AbstractShowHide.ContextItemVariable variable = context_p.getLastVariable(SOURCE_PORTS);
                if (variable != null && variable.getValue() instanceof Collection) {
                    value.putAll("source", (Collection)variable.getValue());
                } else if (noSourcePort == null || Boolean.FALSE.equals(noSourcePort.getValue())) {
                    value.put("source", semantic_p);
                } else {
                    variable = context_p.getLastVariable("sourceParts");
                    if (variable != null && variable.getValue() instanceof Collection) {
                        value.putAll("source", (Collection)variable.getValue());
                    }
                }
                variable = context_p.getLastVariable(TARGET_PORTS);
                if (variable != null && variable.getValue() instanceof Collection) {
                    value.putAll("target", (Collection)variable.getValue());
                } else if (noTargetPort == null || Boolean.FALSE.equals(noTargetPort.getValue())) {
                    value.put("target", semantic_p);
                } else {
                    variable = context_p.getLastVariable("targetParts");
                    if (variable != null && variable.getValue() instanceof Collection) {
                        value.putAll("target", (Collection)variable.getValue());
                    }
                }
            }
        }
        return value;
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        EObject value = lastContext.getValue();
        if (value instanceof PhysicalLinkCategory) {
            String key = lastContext.getKey();
            mapping = "source".equals(key) ? this.getContent().getMapping(MappingConstantsHelper.getMappingABPhysicalCategoryPin(this.getContent().getDDiagram(), value)) : ("target".equals(key) ? this.getContent().getMapping(MappingConstantsHelper.getMappingABPhysicalCategoryPin(this.getContent().getDDiagram(), value)) : this.getContent().getMapping(MappingConstantsHelper.getMappingABPhysicalCategory(this.getContent().getDDiagram())));
        }
        return mapping;
    }

    @Override
    protected boolean isValidEdgeView(DEdge edge_p, DSemanticDecorator sourceView_p, DSemanticDecorator targetView_p) {
        DiagramElementMapping categoryMapping;
        if (sourceView_p.equals(edge_p.getTargetNode()) && targetView_p.equals(edge_p.getSourceNode()) && (categoryMapping = this.getContent().getMapping(MappingConstantsHelper.getMappingABPhysicalCategory(this.getContent().getDDiagram()))).equals(edge_p.getActualMapping())) {
            return true;
        }
        return super.isValidEdgeView(edge_p, sourceView_p, targetView_p);
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }

    @Override
    protected boolean mustShow(DSemanticDecorator source_p, DSemanticDecorator target_p, EObject exchange_p, EdgeMapping edgeMapping_p) {
        if (exchange_p instanceof PhysicalLinkCategory) {
            return ABServices.getService().isValidABPhysicalCategoryEdge((PhysicalLinkCategory)exchange_p, source_p, target_p);
        }
        return super.mustShow(source_p, target_p, exchange_p, edgeMapping_p);
    }

    @Override
    protected boolean mustShow(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        EObject semantic = originCouple_p.getValue();
        if (semantic instanceof Part) {
            for (AbstractShowHide.ContextItemView view : originCouple_p.getViews()) {
                if (view.getViews().get("views").size() <= 0) continue;
                return false;
            }
            return false;
        }
        if (semantic instanceof PhysicalLinkCategory) {
            return true;
        }
        return super.mustShow(originCouple_p, context_p, relatedViews_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        return super.mustHide(originCouple_p, context_p) || semantic instanceof PhysicalLinkCategory;
    }

    @Override
    protected boolean hideInsteadOfRemoveView(DDiagramElement element_p, AbstractShowHide.DiagramContext context_p) {
        EObject target = element_p.getTarget();
        if (target instanceof PhysicalPort) {
            return this.getContent().getDDiagram().isSynchronized();
        }
        return super.hideInsteadOfRemoveView(element_p, context_p);
    }

    @Override
    protected boolean mustHide(DDiagramElement view_p, AbstractShowHide.DiagramContext context_p) {
        PhysicalLink ce;
        EObject target;
        if (view_p.getDiagramElementMapping() instanceof AbstractNodeMapping && (target = view_p.getTarget()) != null && target instanceof PhysicalPort) {
            BasicEList relatedEdges = new BasicEList();
            relatedEdges.addAll((Collection)((EdgeTarget)view_p).getIncomingEdges());
            relatedEdges.addAll((Collection)((EdgeTarget)view_p).getOutgoingEdges());
            for (DEdge edge : relatedEdges) {
                if (edge == null || edge.getTarget() instanceof PhysicalPath || !this.getContent().isVisible((DDiagramElement)edge)) continue;
                return false;
            }
            return true;
        }
        if (view_p.getTarget() instanceof PhysicalLink && view_p instanceof DEdge && this.isDelegation(ce = (PhysicalLink)view_p.getTarget())) {
            EObject targetTarget;
            EObject sourceTarget;
            EdgeTarget source = this.getSourceDelegationView((DEdge)view_p, ce);
            boolean result = true;
            if (result) {
                for (DEdge edge : source.getIncomingEdges()) {
                    if (!(edge.getTarget() instanceof PhysicalLinkCategory)) continue;
                    sourceTarget = ((DSemanticDecorator)edge.getSourceNode()).getTarget();
                    targetTarget = ((DSemanticDecorator)edge.getTargetNode()).getTarget();
                    if (sourceTarget instanceof PhysicalLinkCategory && targetTarget instanceof PhysicalPort) {
                        result = false;
                    }
                    if (!(targetTarget instanceof PhysicalLinkCategory) || !(sourceTarget instanceof PhysicalPort)) continue;
                    result = false;
                }
            }
            if (result) {
                for (DEdge edge : source.getOutgoingEdges()) {
                    if (!(edge.getTarget() instanceof PhysicalLinkCategory)) continue;
                    sourceTarget = ((DSemanticDecorator)edge.getSourceNode()).getTarget();
                    targetTarget = ((DSemanticDecorator)edge.getTargetNode()).getTarget();
                    if (sourceTarget instanceof PhysicalLinkCategory && targetTarget instanceof PhysicalPort) {
                        result = false;
                    }
                    if (!(targetTarget instanceof PhysicalLinkCategory) || !(sourceTarget instanceof PhysicalPort)) continue;
                    result = false;
                }
            }
            if (!result) {
                return result;
            }
        }
        return super.mustHide(view_p, context_p);
    }

    protected EdgeTarget getSourceDelegationView(DEdge view_p, PhysicalLink link_p) {
        EdgeTarget result = view_p.getSourceNode();
        if (!PortExt.getDelegatedPhysicalLinks((PhysicalPort)((PhysicalPort)((AbstractDNode)result).getTarget())).contains(link_p)) {
            result = view_p.getTargetNode();
        }
        return result;
    }

    protected boolean isDelegation(PhysicalLink ce_p) {
        return PhysicalLinkExt.isDelegation((PhysicalLink)ce_p);
    }

    @Override
    protected Collection<DDiagramElement> showNodes(DSemanticDecorator containerView_p, EObject semantic_p, DDiagramContents content_p, AbstractNodeMapping mapping_p) {
        Collection<DDiagramElement> nodes = super.showNodes(containerView_p, semantic_p, content_p, mapping_p);
        if (semantic_p instanceof PhysicalPort) {
            for (DDiagramElement element : nodes) {
                this.getContent().deferredShow(element);
            }
        }
        return nodes;
    }

    @Override
    protected Collection<DDiagramElement> showEdges(DSemanticDecorator source_p, DSemanticDecorator target_p, EObject exchange_p, DDiagramContents content_p, EdgeMapping edgeMapping_p) {
        Collection<DDiagramElement> nodes = super.showEdges(source_p, target_p, exchange_p, content_p, edgeMapping_p);
        if (exchange_p instanceof PhysicalLink) {
            for (DDiagramElement element : nodes) {
                this.getContent().deferredShow(element);
            }
        }
        return nodes;
    }
}

