/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.validation;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.diffmerge.patterns.capella.Messages;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternSymbol;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternVersion;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IPatternConformityStatus;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.environment.IModelEnvironmentUI;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;

public class Checker {
    private static Checker __instance = null;

    public static Checker getInstance() {
        if (__instance == null) {
            __instance = new Checker();
        }
        return __instance;
    }

    protected Checker() {
    }

    protected void addValidationProblem(DiagnosticChain diagnostic_p, ModelElement context_p, String message_p) {
        IModelEnvironmentUI me = PatternsUIPlugin.getDefault().getModelEnvironmentUI();
        BasicDiagnostic newDiag = new BasicDiagnostic(2, me.getText((Object)context_p), 0, message_p, new Object[]{context_p});
        diagnostic_p.add((Diagnostic)newDiag);
    }

    public Diagnostic check(ModelElement target_p) {
        BasicDiagnostic result = new BasicDiagnostic(0, new String(), 0, new String(), new Object[]{target_p});
        IPatternSupport support = CorePatternsPlugin.getDefault().getPatternSupportFor((EObject)target_p);
        if (support != null) {
            List instances = support.getRelatedInstances((EObject)target_p);
            for (IPatternInstance instance : instances) {
                IPatternConformityStatus status;
                List roleElements = LocationsUtil.getRoleElements((IPatternApplication)instance);
                if (!roleElements.contains(target_p)) continue;
                List featuresToIgnore = Collections.emptyList();
                if (CorePatternsPlugin.getDefault().getRepositoryRegistry().getRepositories().isEmpty()) {
                    this.addValidationProblem((DiagnosticChain)result, target_p, Messages.Checker_NoCatalog);
                    break;
                }
                ISemanticRuleProvider provider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor((Object)target_p);
                if (provider != null) {
                    featuresToIgnore = provider.getDefaultOptionalMergeFeatures();
                }
                if ((status = instance.checkConformance(featuresToIgnore)).isOk()) continue;
                String message = this.getFormattedMessage(instance, status);
                this.addValidationProblem((DiagnosticChain)result, target_p, message);
            }
        }
        result.recomputeSeverity();
        return result;
    }

    protected String getFormattedMessage(IPatternInstance instance_p, IPatternConformityStatus status_p) {
        IPatternSymbol symbol;
        String result = status_p.getDescription();
        if (result == null) {
            result = new String();
        }
        String SPACE = " ";
        result = result.replaceAll("\n", " ");
        result = result.replaceAll("\r", " ");
        result = result.replaceAll("\t", " ");
        IPatternVersion version = instance_p.getPatternVersion();
        if (version != null && (symbol = version.getPatternSymbol()) != null && symbol.getName() != null) {
            result = String.valueOf(Messages.Checker_Pattern) + " " + symbol.getName() + ": " + result;
        }
        return result;
    }
}

